/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.message;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.engine.state.immutable.MessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.TransientPendingSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.stream.api.ReadonlyStreamProcessorContext;
import io.camunda.zeebe.stream.api.StreamProcessorLifecycleAware;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.slf4j.Logger;

public final class DbMessageSubscriptionState
implements MutableMessageSubscriptionState,
PendingMessageSubscriptionState,
StreamProcessorLifecycleAware {
    private static final Logger LOG = Loggers.STREAM_PROCESSING;
    private final DbLong elementInstanceKey = new DbLong();
    private final DbString messageName = new DbString();
    private final MessageSubscription messageSubscription = new MessageSubscription();
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName = new DbCompositeKey<DbLong, DbString>(this.elementInstanceKey, this.messageName);
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, MessageSubscription> subscriptionColumnFamily;
    private final DbString tenantIdKey;
    private final DbString correlationKey;
    private final DbTenantAwareKey<DbCompositeKey<DbString, DbString>> tenantAwareNameAndCorrelationKey;
    private final DbCompositeKey<DbTenantAwareKey<DbCompositeKey<DbString, DbString>>, DbLong> tenantAwareNameCorrelationAndElementInstanceKey;
    private final ColumnFamily<DbCompositeKey<DbTenantAwareKey<DbCompositeKey<DbString, DbString>>, DbLong>, DbNil> messageNameAndCorrelationKeyColumnFamily;
    private final TransientPendingSubscriptionState transientState;

    public DbMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, TransientPendingSubscriptionState transientState) {
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, this.messageSubscription);
        this.tenantIdKey = new DbString();
        this.correlationKey = new DbString();
        this.tenantAwareNameAndCorrelationKey = new DbTenantAwareKey<DbCompositeKey<DbString, DbString>>(this.tenantIdKey, new DbCompositeKey<DbString, DbString>(this.messageName, this.correlationKey), DbTenantAwareKey.PlacementType.PREFIX);
        this.tenantAwareNameCorrelationAndElementInstanceKey = new DbCompositeKey<DbTenantAwareKey<DbCompositeKey<DbString, DbString>>, DbLong>(this.tenantAwareNameAndCorrelationKey, this.elementInstanceKey);
        this.messageNameAndCorrelationKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_NAME_AND_CORRELATION_KEY, transactionContext, this.tenantAwareNameCorrelationAndElementInstanceKey, DbNil.INSTANCE);
        this.transientState = transientState;
    }

    @Override
    public void onRecovered(ReadonlyStreamProcessorContext context) {
        this.subscriptionColumnFamily.forEach(subscription -> {
            if (subscription.isCorrelating()) {
                this.transientState.add(new TransientPendingSubscriptionState.PendingSubscription(this.elementInstanceKey.getValue(), this.messageName.toString(), this.tenantIdKey.toString()), ActorClock.currentTimeMillis());
            }
        });
    }

    @Override
    public MessageSubscription get(long elementInstanceKey, DirectBuffer messageName) {
        this.messageName.wrapBuffer(messageName);
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        return this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
    }

    @Override
    public void visitSubscriptions(String tenantId, DirectBuffer messageName, DirectBuffer correlationKey, MessageSubscriptionState.MessageSubscriptionVisitor visitor) {
        this.tenantIdKey.wrapString(tenantId);
        this.messageName.wrapBuffer(messageName);
        this.correlationKey.wrapBuffer(correlationKey);
        this.messageNameAndCorrelationKeyColumnFamily.whileEqualPrefix(this.tenantAwareNameAndCorrelationKey, (compositeKey, nil) -> this.visitMessageSubscription(this.elementKeyAndMessageName, visitor));
    }

    @Override
    public boolean existSubscriptionForElementInstance(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
        return this.subscriptionColumnFamily.exists(this.elementKeyAndMessageName);
    }

    @Override
    public void put(long key, MessageSubscriptionRecord record) {
        this.tenantIdKey.wrapString(record.getTenantId());
        this.elementInstanceKey.wrapLong(record.getElementInstanceKey());
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        this.messageSubscription.setKey(key).setRecord(record).setCorrelating(false);
        this.subscriptionColumnFamily.insert(this.elementKeyAndMessageName, this.messageSubscription);
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.messageNameAndCorrelationKeyColumnFamily.insert(this.tenantAwareNameCorrelationAndElementInstanceKey, DbNil.INSTANCE);
    }

    @Override
    public void updateToCorrelatingState(MessageSubscriptionRecord record) {
        MessageSubscription subscription;
        long messageKey = record.getMessageKey();
        DirectBuffer messageVariables = record.getVariablesBuffer();
        if (record == this.messageSubscription.getRecord()) {
            messageVariables = BufferUtil.cloneBuffer(record.getVariablesBuffer());
        }
        if ((subscription = this.get(record.getElementInstanceKey(), record.getMessageNameBuffer())) == null) {
            throw new IllegalStateException(String.format("Expected subscription but not found. [element-instance-key: %d, message-name: %s]", record.getElementInstanceKey(), record.getMessageName()));
        }
        subscription.getRecord().setMessageKey(messageKey).setVariables(messageVariables);
        this.updateCorrelatingFlag(subscription, true);
        this.transientState.update(new TransientPendingSubscriptionState.PendingSubscription(subscription.getRecord().getElementInstanceKey(), subscription.getRecord().getMessageName(), subscription.getRecord().getTenantId()), ActorClock.currentTimeMillis());
    }

    @Override
    public void updateToCorrelatedState(MessageSubscription subscription) {
        this.updateCorrelatingFlag(subscription, false);
        MessageSubscriptionRecord record = subscription.getRecord();
        this.transientState.remove(new TransientPendingSubscriptionState.PendingSubscription(record.getElementInstanceKey(), record.getMessageName(), record.getTenantId()));
    }

    @Override
    public boolean remove(long elementInstanceKey, DirectBuffer messageName) {
        boolean found;
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
        MessageSubscription messageSubscription = this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
        boolean bl = found = messageSubscription != null;
        if (found) {
            this.remove(messageSubscription);
        }
        return found;
    }

    @Override
    public void remove(MessageSubscription subscription) {
        this.subscriptionColumnFamily.deleteExisting(this.elementKeyAndMessageName);
        MessageSubscriptionRecord record = subscription.getRecord();
        this.tenantIdKey.wrapString(record.getTenantId());
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.messageNameAndCorrelationKeyColumnFamily.deleteExisting(this.tenantAwareNameCorrelationAndElementInstanceKey);
        this.transientState.remove(new TransientPendingSubscriptionState.PendingSubscription(this.elementInstanceKey.getValue(), this.messageName.toString(), this.tenantIdKey.toString()));
    }

    private void updateCorrelatingFlag(MessageSubscription subscription, boolean correlating) {
        MessageSubscriptionRecord record = subscription.getRecord();
        this.elementInstanceKey.wrapLong(record.getElementInstanceKey());
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        subscription.setCorrelating(correlating);
        this.subscriptionColumnFamily.update(this.elementKeyAndMessageName, subscription);
    }

    private Boolean visitMessageSubscription(DbCompositeKey<DbLong, DbString> elementKeyAndMessageName, MessageSubscriptionState.MessageSubscriptionVisitor visitor) {
        MessageSubscription messageSubscription = this.subscriptionColumnFamily.get(elementKeyAndMessageName);
        if (messageSubscription == null) {
            throw new IllegalStateException(String.format("Expected to find subscription with key %d and %s, but no subscription found", elementKeyAndMessageName.first().getValue(), elementKeyAndMessageName.second()));
        }
        return visitor.visit(messageSubscription);
    }

    @Override
    public void visitPending(long deadline, MessageSubscriptionState.MessageSubscriptionVisitor visitor) {
        for (TransientPendingSubscriptionState.PendingSubscription pendingSubscription : this.transientState.entriesBefore(deadline)) {
            MessageSubscription subscription = this.get(pendingSubscription.elementInstanceKey(), BufferUtil.wrapString(pendingSubscription.messageName()));
            if (subscription == null) {
                LOG.warn("Expected to find a subscription with key {} and message name {}, but none found. The state is inconsistent.", (Object)pendingSubscription.elementInstanceKey(), (Object)pendingSubscription.messageName());
                continue;
            }
            visitor.visit(subscription);
        }
    }

    @Override
    public void onSent(long elementInstanceKey, String messageName, String tenantId, long timestampMs) {
        this.transientState.update(new TransientPendingSubscriptionState.PendingSubscription(elementInstanceKey, messageName, tenantId), timestampMs);
    }
}

