/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.deployment.PersistedDecision;
import io.camunda.zeebe.engine.state.deployment.PersistedDecisionRequirements;
import io.camunda.zeebe.engine.state.deployment.VersionInfo;
import io.camunda.zeebe.engine.state.immutable.PendingMessageSubscriptionState;
import io.camunda.zeebe.engine.state.immutable.PendingProcessMessageSubscriptionState;
import io.camunda.zeebe.engine.state.instance.ElementInstance;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.engine.state.message.ProcessMessageSubscription;
import io.camunda.zeebe.engine.state.migration.TemporaryVariables;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbDecisionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbJobMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbMessageMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbMessageStartEventSubscriptionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbMessageSubscriptionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbProcessMessageSubscriptionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_3.DbProcessMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_4.DbSignalSubscriptionMigrationState;
import io.camunda.zeebe.engine.state.migration.to_8_5.DbColumnFamilyCorrectionMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableElementInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableEventScopeInstanceState;
import io.camunda.zeebe.engine.state.mutable.MutableMessageSubscriptionState;
import io.camunda.zeebe.engine.state.mutable.MutableMigrationState;
import io.camunda.zeebe.engine.state.mutable.MutableProcessMessageSubscriptionState;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.ProcessMessageSubscriptionRecord;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class DbMigrationState
implements MutableMigrationState {
    private static final long NO_PARENT_KEY = -1L;
    private static final String MIGRATED_BY_VERSION = "migrated-by-version";
    private final DbLong messageSubscriptionSentTime;
    private final DbLong messageSubscriptionElementInstanceKey;
    private final DbString messageSubscriptionMessageName;
    private final DbCompositeKey<DbLong, DbString> messageSubscriptionElementKeyAndMessageName;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> messageSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> messageSubscriptionSentTimeColumnFamily;
    private final DbLong processSubscriptionSentTime;
    private final DbLong processSubscriptionElementInstanceKey;
    private final DbString processSubscriptionMessageName;
    private final DbCompositeKey<DbLong, DbString> processSubscriptionElementKeyAndMessageName;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> processSubscriptionSentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> processSubscriptionSentTimeColumnFamily;
    private final ColumnFamily<DbLong, TemporaryVariables> temporaryVariableColumnFamily;
    private final DbLong dbDecisionKey;
    private final PersistedDecision dbPersistedDecision;
    private final DbString dbDecisionId;
    private final DbForeignKey<DbLong> fkDecision;
    private final DbInt dbDecisionVersion;
    private final ColumnFamily<DbLong, PersistedDecision> decisionsByKeyColumnFamily;
    private final DbCompositeKey<DbString, DbInt> decisionKeyAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionKeyByDecisionIdAndVersion;
    private final DbLong dbDecisionRequirementsKey;
    private final DbForeignKey<DbLong> fkDecisionRequirements;
    private final PersistedDecisionRequirements dbPersistedDecisionRequirements;
    private final DbInt dbDecisionRequirementsVersion;
    private final DbString dbDecisionRequirementsId;
    private final ColumnFamily<DbLong, PersistedDecisionRequirements> decisionRequirementsByKeyColumnFamily;
    private final DbCompositeKey<DbString, DbInt> decisionRequirementsIdAndVersion;
    private final ColumnFamily<DbCompositeKey<DbString, DbInt>, DbForeignKey<DbLong>> decisionRequirementsKeyByIdAndVersionColumnFamily;
    private final DbLong elementInstanceKey;
    private final ElementInstance elementInstance;
    private final ColumnFamily<DbLong, ElementInstance> elementInstanceColumnFamily;
    private final DbLong processDefinitionKey;
    private final DbCompositeKey<DbLong, DbLong> processInstanceKeyByProcessDefinitionKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> processInstanceKeyByProcessDefinitionKeyColumnFamily;
    private final DbForeignKey<DbLong> parentKey;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>> parentChildKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>, DbNil> parentChildColumnFamily;
    private final DbString processIdKey;
    private final ColumnFamily<DbString, VersionInfo> processVersionInfoColumnFamily;
    private final DbProcessMigrationState processMigrationState;
    private final DbDecisionMigrationState decisionMigrationState;
    private final DbMessageMigrationState messageMigrationState;
    private final DbMessageStartEventSubscriptionMigrationState messageStartEventSubscriptionMigrationState;
    private final DbMessageSubscriptionMigrationState messageSubscriptionMigrationState;
    private final DbProcessMessageSubscriptionMigrationState processMessageSubscriptionMigrationState;
    private final DbJobMigrationState jobMigrationState;
    private final DbSignalSubscriptionMigrationState signalSubscriptionMigrationState;
    private final ColumnFamily<DbString, DbString> migrationsState;
    private final DbString migratedByVersionKey = new DbString();
    private final DbString migratedByVersionValue = new DbString();
    private final DbColumnFamilyCorrectionMigrationState columnFamilyCorrectionMigrationState;

    public DbMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.messageSubscriptionElementInstanceKey = new DbLong();
        this.messageSubscriptionMessageName = new DbString();
        this.messageSubscriptionElementKeyAndMessageName = new DbCompositeKey<DbLong, DbString>(this.messageSubscriptionElementInstanceKey, this.messageSubscriptionMessageName);
        this.messageSubscriptionSentTime = new DbLong();
        this.messageSubscriptionSentTimeCompositeKey = new DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>(this.messageSubscriptionSentTime, this.messageSubscriptionElementKeyAndMessageName);
        this.messageSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.messageSubscriptionSentTimeCompositeKey, DbNil.INSTANCE);
        this.processSubscriptionElementInstanceKey = new DbLong();
        this.processSubscriptionMessageName = new DbString();
        this.processSubscriptionElementKeyAndMessageName = new DbCompositeKey<DbLong, DbString>(this.processSubscriptionElementInstanceKey, this.processSubscriptionMessageName);
        this.processSubscriptionSentTime = new DbLong();
        this.processSubscriptionSentTimeCompositeKey = new DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>(this.processSubscriptionSentTime, this.processSubscriptionElementKeyAndMessageName);
        this.processSubscriptionSentTimeColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PROCESS_SUBSCRIPTION_BY_SENT_TIME, transactionContext, this.processSubscriptionSentTimeCompositeKey, DbNil.INSTANCE);
        DbLong temporaryVariablesKeyInstance = new DbLong();
        TemporaryVariables temporaryVariablesValue = new TemporaryVariables();
        this.temporaryVariableColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.TEMPORARY_VARIABLE_STORE, transactionContext, temporaryVariablesKeyInstance, temporaryVariablesValue);
        this.dbDecisionKey = new DbLong();
        this.dbPersistedDecision = new PersistedDecision();
        this.decisionsByKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISIONS, transactionContext, this.dbDecisionKey, this.dbPersistedDecision);
        this.dbDecisionId = new DbString();
        this.fkDecision = new DbForeignKey<DbLong>(this.dbDecisionKey, ZbColumnFamilies.DEPRECATED_DMN_DECISIONS);
        this.dbDecisionVersion = new DbInt();
        this.decisionKeyAndVersion = new DbCompositeKey<DbString, DbInt>(this.dbDecisionId, this.dbDecisionVersion);
        this.decisionKeyByDecisionIdAndVersion = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION, transactionContext, this.decisionKeyAndVersion, this.fkDecision);
        this.dbDecisionRequirementsKey = new DbLong();
        this.fkDecisionRequirements = new DbForeignKey<DbLong>(this.dbDecisionRequirementsKey, ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS);
        this.dbPersistedDecisionRequirements = new PersistedDecisionRequirements();
        this.decisionRequirementsByKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS, transactionContext, this.dbDecisionRequirementsKey, this.dbPersistedDecisionRequirements);
        this.dbDecisionRequirementsVersion = new DbInt();
        this.dbDecisionRequirementsId = new DbString();
        this.decisionRequirementsIdAndVersion = new DbCompositeKey<DbString, DbInt>(this.dbDecisionRequirementsId, this.dbDecisionRequirementsVersion);
        this.decisionRequirementsKeyByIdAndVersionColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_DMN_DECISION_REQUIREMENTS_KEY_BY_DECISION_REQUIREMENT_ID_AND_VERSION, transactionContext, this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        this.elementInstanceKey = new DbLong();
        this.elementInstance = new ElementInstance();
        this.elementInstanceColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.ELEMENT_INSTANCE_KEY, transactionContext, this.elementInstanceKey, this.elementInstance);
        this.processDefinitionKey = new DbLong();
        this.processInstanceKeyByProcessDefinitionKey = new DbCompositeKey<DbLong, DbLong>(this.processDefinitionKey, this.elementInstanceKey);
        this.processInstanceKeyByProcessDefinitionKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.PROCESS_INSTANCE_KEY_BY_DEFINITION_KEY, transactionContext, this.processInstanceKeyByProcessDefinitionKey, DbNil.INSTANCE);
        this.parentKey = new DbForeignKey<DbLong>(new DbLong(), ZbColumnFamilies.ELEMENT_INSTANCE_KEY, DbForeignKey.MatchType.Full, k -> k.getValue() == -1L);
        this.parentChildKey = new DbCompositeKey<DbForeignKey<DbLong>, DbForeignKey<DbLong>>(this.parentKey, new DbForeignKey<DbLong>(this.elementInstanceKey, ZbColumnFamilies.ELEMENT_INSTANCE_KEY));
        this.parentChildColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.ELEMENT_INSTANCE_PARENT_CHILD, transactionContext, this.parentChildKey, DbNil.INSTANCE);
        this.processIdKey = new DbString();
        this.processVersionInfoColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_PROCESS_VERSION, transactionContext, this.processIdKey, new VersionInfo());
        this.processMigrationState = new DbProcessMigrationState(zeebeDb, transactionContext);
        this.decisionMigrationState = new DbDecisionMigrationState(zeebeDb, transactionContext);
        this.messageMigrationState = new DbMessageMigrationState(zeebeDb, transactionContext);
        this.messageStartEventSubscriptionMigrationState = new DbMessageStartEventSubscriptionMigrationState(zeebeDb, transactionContext);
        this.messageSubscriptionMigrationState = new DbMessageSubscriptionMigrationState(zeebeDb, transactionContext);
        this.processMessageSubscriptionMigrationState = new DbProcessMessageSubscriptionMigrationState(zeebeDb, transactionContext);
        this.jobMigrationState = new DbJobMigrationState(zeebeDb, transactionContext);
        this.signalSubscriptionMigrationState = new DbSignalSubscriptionMigrationState(zeebeDb, transactionContext);
        this.migratedByVersionKey.wrapString(MIGRATED_BY_VERSION);
        this.migrationsState = zeebeDb.createColumnFamily(ZbColumnFamilies.MIGRATIONS_STATE, transactionContext, this.migratedByVersionKey, this.migratedByVersionValue);
        this.columnFamilyCorrectionMigrationState = new DbColumnFamilyCorrectionMigrationState(zeebeDb, transactionContext);
    }

    @Override
    public void migrateMessageSubscriptionSentTime(MutableMessageSubscriptionState messageSubscriptionState, PendingMessageSubscriptionState transientState) {
        this.messageSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.first()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.second();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.first()).getValue();
            MessageSubscription messageSubscription = messageSubscriptionState.get(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.second()).getBuffer());
            if (messageSubscription != null) {
                messageSubscriptionState.updateToCorrelatingState(messageSubscription.getRecord());
                transientState.onSent(elementInstanceKey, BufferUtil.bufferAsString(messageName), "<default>", sentTime);
            }
            this.messageSubscriptionSentTimeColumnFamily.deleteExisting((DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>)key);
        });
    }

    @Override
    public void migrateProcessMessageSubscriptionSentTime(MutableProcessMessageSubscriptionState persistentState, PendingProcessMessageSubscriptionState transientState) {
        this.processSubscriptionSentTimeColumnFamily.forEach((key, value) -> {
            DirectBuffer messageName;
            long sentTime = ((DbLong)key.first()).getValue();
            DbCompositeKey elementKeyAndMessageName = (DbCompositeKey)key.second();
            long elementInstanceKey = ((DbLong)elementKeyAndMessageName.first()).getValue();
            ProcessMessageSubscription processMessageSubscription = persistentState.getSubscription(elementInstanceKey, messageName = ((DbString)elementKeyAndMessageName.second()).getBuffer(), "<default>");
            if (processMessageSubscription != null) {
                ProcessMessageSubscriptionRecord record = processMessageSubscription.getRecord();
                ProcessMessageSubscriptionRecord exclusiveCopy = new ProcessMessageSubscriptionRecord();
                exclusiveCopy.wrap(record);
                if (processMessageSubscription.isOpening()) {
                    persistentState.updateToOpeningState(exclusiveCopy);
                    transientState.onSent(exclusiveCopy, sentTime);
                } else if (processMessageSubscription.isClosing()) {
                    persistentState.updateToClosingState(exclusiveCopy);
                    transientState.onSent(exclusiveCopy, sentTime);
                }
            }
            this.processSubscriptionSentTimeColumnFamily.deleteExisting((DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>)key);
        });
    }

    @Override
    public void migrateTemporaryVariables(MutableEventScopeInstanceState eventScopeInstanceState, MutableElementInstanceState elementInstanceState) {
        this.temporaryVariableColumnFamily.forEach((key, value) -> {
            long eventKey = -1L;
            String elementId = "migrated-variable-" + key.getValue();
            DirectBuffer elementIdBuffer = BufferUtil.wrapString(elementId);
            ElementInstance elementInstance = elementInstanceState.getInstance(key.getValue());
            if (elementInstance != null && elementInstance.getValue().getBpmnElementType().equals((Object)BpmnElementType.EVENT_SUB_PROCESS)) {
                long flowScopeKey = elementInstance.getValue().getFlowScopeKey();
                eventScopeInstanceState.triggerStartEvent(flowScopeKey, -1L, elementIdBuffer, value.get(), elementInstance.getValue().getProcessInstanceKey());
                while (eventScopeInstanceState.pollEventTrigger(key.getValue()) != null) {
                }
            } else {
                eventScopeInstanceState.triggerStartEvent(key.getValue(), -1L, elementIdBuffer, value.get(), -1L);
            }
            this.temporaryVariableColumnFamily.deleteExisting((DbLong)key);
        });
    }

    @Override
    public void migrateDecisionsPopulateDecisionVersionByDecisionIdAndDecisionKey() {
        this.decisionsByKeyColumnFamily.forEach((key, value) -> {
            this.dbDecisionId.wrapBuffer(value.getDecisionId());
            this.dbDecisionKey.wrapLong(value.getDecisionKey());
            this.dbDecisionVersion.wrapInt(value.getVersion());
            this.decisionKeyByDecisionIdAndVersion.insert(this.decisionKeyAndVersion, this.fkDecision);
        });
    }

    @Override
    public void migrateDrgPopulateDrgVersionByDrgIdAndKey() {
        this.decisionRequirementsByKeyColumnFamily.forEach((key, value) -> {
            this.dbDecisionRequirementsId.wrapBuffer(value.getDecisionRequirementsId());
            this.dbDecisionRequirementsKey.wrapLong(value.getDecisionRequirementsKey());
            this.dbDecisionRequirementsVersion.wrapInt(value.getDecisionRequirementsVersion());
            this.decisionRequirementsKeyByIdAndVersionColumnFamily.insert(this.decisionRequirementsIdAndVersion, this.fkDecisionRequirements);
        });
    }

    @Override
    public void migrateElementInstancePopulateProcessInstanceByDefinitionKey() {
        this.parentKey.inner().wrapLong(-1L);
        this.parentChildColumnFamily.whileEqualPrefix(this.parentKey, (key, nil) -> {
            this.elementInstanceKey.wrapLong(((DbLong)((DbForeignKey)key.second()).inner()).getValue());
            ElementInstance processInstance = this.elementInstanceColumnFamily.get(this.elementInstanceKey);
            this.processDefinitionKey.wrapLong(processInstance.getValue().getProcessDefinitionKey());
            this.processInstanceKeyByProcessDefinitionKeyColumnFamily.upsert(this.processInstanceKeyByProcessDefinitionKey, DbNil.INSTANCE);
        });
    }

    @Override
    public void migrateProcessStateForMultiTenancy() {
        this.processMigrationState.migrateProcessStateForMultiTenancy();
    }

    @Override
    public void migrateDecisionStateForMultiTenancy() {
        this.decisionMigrationState.migrateDecisionStateForMultiTenancy();
    }

    @Override
    public void migrateMessageStateForMultiTenancy() {
        this.messageMigrationState.migrateMessageStateForMultiTenancy();
    }

    @Override
    public void migrateMessageStartEventSubscriptionForMultiTenancy() {
        this.messageStartEventSubscriptionMigrationState.migrateMessageStartEventSubscriptionForMultiTenancy();
    }

    @Override
    public void migrateMessageEventSubscriptionForMultiTenancy() {
        this.messageSubscriptionMigrationState.migrateMessageSubscriptionForMultiTenancy();
    }

    @Override
    public void migrateProcessMessageSubscriptionForMultiTenancy() {
        this.processMessageSubscriptionMigrationState.migrateProcessMessageSubscriptionForMultiTenancy();
    }

    @Override
    public void migrateJobStateForMultiTenancy() {
        this.jobMigrationState.migrateJobStateForMultiTenancy();
    }

    @Override
    public void migrateSignalSubscriptionStateForMultiTenancy() {
        this.signalSubscriptionMigrationState.migrateSignalSubscriptionStateForMultiTenancy();
    }

    @Override
    public boolean shouldRunElementInstancePopulateProcessInstanceByDefinitionKey() {
        this.parentKey.inner().wrapLong(-1L);
        return this.processInstanceKeyByProcessDefinitionKeyColumnFamily.isEmpty() || this.processInstanceKeyByProcessDefinitionKeyColumnFamily.count() != this.parentChildColumnFamily.countEqualPrefix(this.parentKey);
    }

    @Override
    public String getMigratedByVersion() {
        DbString value = this.migrationsState.get(this.migratedByVersionKey);
        return value == null ? null : value.toString();
    }

    @Override
    public void setMigratedByVersion(String version) {
        this.migratedByVersionValue.wrapString(version);
        this.migrationsState.upsert(this.migratedByVersionKey, this.migratedByVersionValue);
    }

    @Override
    public void correctColumnFamilyPrefix() {
        this.columnFamilyCorrectionMigrationState.correctColumnFamilyPrefix();
    }
}

