/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration;

import io.camunda.zeebe.util.SemanticVersion;
import java.util.Optional;

final class VersionCompatibilityCheck {
    private VersionCompatibilityCheck() {
    }

    public static CheckResult check(String previousVersion, String currentVersion) {
        SemanticVersion current;
        if (previousVersion == null) {
            return new CheckResult.Indeterminate.PreviousVersionUnknown(currentVersion);
        }
        if (currentVersion == null) {
            return new CheckResult.Indeterminate.CurrentVersionUnknown(previousVersion);
        }
        Optional<SemanticVersion> parsedPreviousVersion = SemanticVersion.parse(previousVersion);
        Optional<SemanticVersion> parsedCurrentVersion = SemanticVersion.parse(currentVersion);
        if (parsedPreviousVersion.isEmpty()) {
            return new CheckResult.Indeterminate.PreviousVersionInvalid(previousVersion, currentVersion);
        }
        if (parsedCurrentVersion.isEmpty()) {
            return new CheckResult.Indeterminate.CurrentVersionInvalid(previousVersion, currentVersion);
        }
        SemanticVersion previous = parsedPreviousVersion.get();
        if (previous.compareTo(current = parsedCurrentVersion.get()) == 0) {
            return new CheckResult.Compatible.SameVersion(current);
        }
        if (previous.preRelease() != null || current.preRelease() != null) {
            return new CheckResult.Incompatible.UseOfPreReleaseVersion(previous, current);
        }
        if (previous.compareTo(current) > 0) {
            if (previous.major() > current.major()) {
                return new CheckResult.Incompatible.MajorDowngrade(previous, current);
            }
            if (previous.minor() > current.minor()) {
                return new CheckResult.Incompatible.MinorDowngrade(previous, current);
            }
            return new CheckResult.Incompatible.PatchDowngrade(previous, current);
        }
        if (previous.major() < current.major()) {
            return new CheckResult.Incompatible.MajorUpgrade(previous, current);
        }
        if (previous.minor() - current.minor() < -1) {
            return new CheckResult.Incompatible.SkippedMinorVersion(previous, current);
        }
        if (previous.minor() < current.minor()) {
            return new CheckResult.Compatible.MinorUpgrade(previous, current);
        }
        return new CheckResult.Compatible.PatchUpgrade(previous, current);
    }

    static sealed interface CheckResult {

        public static sealed interface Compatible
        extends CheckResult {

            public record MinorUpgrade(SemanticVersion from, SemanticVersion to) implements Compatible
            {
            }

            public record PatchUpgrade(SemanticVersion from, SemanticVersion to) implements Compatible
            {
            }

            public record SameVersion(SemanticVersion version) implements Compatible
            {
            }
        }

        public static sealed interface Incompatible
        extends CheckResult {

            public record MajorDowngrade(SemanticVersion from, SemanticVersion to) implements Incompatible
            {
            }

            public record MinorDowngrade(SemanticVersion from, SemanticVersion to) implements Incompatible
            {
            }

            public record PatchDowngrade(SemanticVersion from, SemanticVersion to) implements Incompatible
            {
            }

            public record UseOfPreReleaseVersion(SemanticVersion from, SemanticVersion to) implements Incompatible
            {
            }

            public record SkippedMinorVersion(SemanticVersion from, SemanticVersion to) implements Incompatible
            {
            }

            public record MajorUpgrade(SemanticVersion from, SemanticVersion to) implements Incompatible
            {
            }
        }

        public static sealed interface Indeterminate
        extends CheckResult {

            public record CurrentVersionInvalid(String previousVersion, String currentVersion) implements Indeterminate
            {
            }

            public record PreviousVersionInvalid(String previousVersion, String currentVersion) implements Indeterminate
            {
            }

            public record CurrentVersionUnknown(String previousVersion) implements Indeterminate
            {
            }

            public record PreviousVersionUnknown(String currentVersion) implements Indeterminate
            {
            }
        }
    }
}

