/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3.legacy;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbForeignKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.metrics.BufferedMessagesMetrics;
import io.camunda.zeebe.engine.state.message.StoredMessage;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageRecord;
import org.agrona.DirectBuffer;

public final class LegacyMessageState {
    private static final String DEADLINE_MESSAGE_COUNT_KEY = "deadline_message_count";
    private final ColumnFamily<DbLong, StoredMessage> messageColumnFamily;
    private final DbLong messageKey = new DbLong();
    private final DbForeignKey<DbLong> fkMessage = new DbForeignKey<DbLong>(this.messageKey, ZbColumnFamilies.MESSAGE_KEY);
    private final StoredMessage message = new StoredMessage();
    private final DbString messageName;
    private final DbString correlationKey;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbForeignKey<DbLong>> nameCorrelationMessageKey;
    private final DbCompositeKey<DbString, DbString> nameAndCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbForeignKey<DbLong>>, DbNil> nameCorrelationMessageColumnFamily;
    private final DbLong deadline;
    private final DbCompositeKey<DbLong, DbForeignKey<DbLong>> deadlineMessageKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbForeignKey<DbLong>>, DbNil> deadlineColumnFamily;
    private final DbLong messagesDeadlineCount;
    private final DbString messagesDeadlineCountKey;
    private final ColumnFamily<DbString, DbLong> messagesDeadlineCountColumnFamily;
    private final DbString messageId;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbString> nameCorrelationMessageIdKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbString>, DbNil> messageIdColumnFamily;
    private final DbCompositeKey<DbForeignKey<DbLong>, DbString> messageBpmnProcessIdKey;
    private final DbString bpmnProcessIdKey;
    private final ColumnFamily<DbCompositeKey<DbForeignKey<DbLong>, DbString>, DbNil> correlatedMessageColumnFamily;
    private final DbCompositeKey<DbString, DbString> bpmnProcessIdCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbString>, DbNil> activeProcessInstancesByCorrelationKeyColumnFamily;
    private final DbLong processInstanceKey;
    private final ColumnFamily<DbLong, DbString> processInstanceCorrelationKeyColumnFamily;
    private final BufferedMessagesMetrics bufferedMessagesMetrics;
    private Long localMessageDeadlineCount = 0L;

    public LegacyMessageState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext, int partitionId) {
        this.messageColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_KEY, transactionContext, this.messageKey, this.message);
        this.messageName = new DbString();
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey<DbString, DbString>(this.messageName, this.correlationKey);
        this.nameCorrelationMessageKey = new DbCompositeKey<DbCompositeKey<DbString, DbString>, DbForeignKey<DbLong>>(this.nameAndCorrelationKey, this.fkMessage);
        this.nameCorrelationMessageColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_MESSAGES, transactionContext, this.nameCorrelationMessageKey, DbNil.INSTANCE);
        this.deadline = new DbLong();
        this.deadlineMessageKey = new DbCompositeKey<DbLong, DbForeignKey<DbLong>>(this.deadline, this.fkMessage);
        this.deadlineColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_DEADLINES, transactionContext, this.deadlineMessageKey, DbNil.INSTANCE);
        this.messagesDeadlineCount = new DbLong();
        this.messagesDeadlineCountKey = new DbString();
        this.messagesDeadlineCountColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_STATS, transactionContext, this.messagesDeadlineCountKey, this.messagesDeadlineCount);
        this.messagesDeadlineCountKey.wrapString(DEADLINE_MESSAGE_COUNT_KEY);
        this.messageId = new DbString();
        this.nameCorrelationMessageIdKey = new DbCompositeKey<DbCompositeKey<DbString, DbString>, DbString>(this.nameAndCorrelationKey, this.messageId);
        this.messageIdColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_IDS, transactionContext, this.nameCorrelationMessageIdKey, DbNil.INSTANCE);
        this.bpmnProcessIdKey = new DbString();
        this.messageBpmnProcessIdKey = new DbCompositeKey<DbForeignKey<DbLong>, DbString>(this.fkMessage, this.bpmnProcessIdKey);
        this.correlatedMessageColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_CORRELATED, transactionContext, this.messageBpmnProcessIdKey, DbNil.INSTANCE);
        this.bpmnProcessIdCorrelationKey = new DbCompositeKey<DbString, DbString>(this.bpmnProcessIdKey, this.correlationKey);
        this.activeProcessInstancesByCorrelationKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_PROCESSES_ACTIVE_BY_CORRELATION_KEY, transactionContext, this.bpmnProcessIdCorrelationKey, DbNil.INSTANCE);
        this.processInstanceKey = new DbLong();
        this.processInstanceCorrelationKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_PROCESS_INSTANCE_CORRELATION_KEYS, transactionContext, this.processInstanceKey, this.correlationKey);
        this.bufferedMessagesMetrics = new BufferedMessagesMetrics(partitionId);
    }

    public void put(long key, MessageRecord record) {
        this.messageKey.wrapLong(key);
        this.message.setMessageKey(key).setMessage(record);
        this.messageColumnFamily.insert(this.messageKey, this.message);
        this.messageName.wrapBuffer(record.getNameBuffer());
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.nameCorrelationMessageColumnFamily.insert(this.nameCorrelationMessageKey, DbNil.INSTANCE);
        this.deadline.wrapLong(record.getDeadline());
        this.deadlineColumnFamily.insert(this.deadlineMessageKey, DbNil.INSTANCE);
        this.localMessageDeadlineCount = this.localMessageDeadlineCount + 1L;
        this.messagesDeadlineCount.wrapLong(this.localMessageDeadlineCount);
        this.messagesDeadlineCountColumnFamily.upsert(this.messagesDeadlineCountKey, this.messagesDeadlineCount);
        this.bufferedMessagesMetrics.setBufferedMessagesCounter(this.localMessageDeadlineCount);
        DirectBuffer messageId = record.getMessageIdBuffer();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.upsert(this.nameCorrelationMessageIdKey, DbNil.INSTANCE);
        }
    }

    public ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbForeignKey<DbLong>>, DbNil> getNameCorrelationMessageColumnFamily() {
        return this.nameCorrelationMessageColumnFamily;
    }
}

