/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_3.legacy;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.message.MessageSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.message.MessageSubscriptionRecord;

public final class LegacyMessageSubscriptionState {
    private final DbLong elementInstanceKey = new DbLong();
    private final DbString messageName = new DbString();
    private final MessageSubscription messageSubscription = new MessageSubscription();
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName = new DbCompositeKey<DbLong, DbString>(this.elementInstanceKey, this.messageName);
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, MessageSubscription> subscriptionColumnFamily;
    private final DbString correlationKey;
    private final DbCompositeKey<DbString, DbString> nameAndCorrelationKey;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong> nameCorrelationAndElementInstanceKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong>, DbNil> messageNameAndCorrelationKeyColumnFamily;

    public LegacyMessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_KEY, transactionContext, this.elementKeyAndMessageName, this.messageSubscription);
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey<DbString, DbString>(this.messageName, this.correlationKey);
        this.nameCorrelationAndElementInstanceKey = new DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong>(this.nameAndCorrelationKey, this.elementInstanceKey);
        this.messageNameAndCorrelationKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_MESSAGE_SUBSCRIPTION_BY_NAME_AND_CORRELATION_KEY, transactionContext, this.nameCorrelationAndElementInstanceKey, DbNil.INSTANCE);
    }

    public void put(long key, MessageSubscriptionRecord record) {
        this.elementInstanceKey.wrapLong(record.getElementInstanceKey());
        this.messageName.wrapBuffer(record.getMessageNameBuffer());
        this.messageSubscription.setKey(key).setRecord(record).setCorrelating(false);
        this.subscriptionColumnFamily.insert(this.elementKeyAndMessageName, this.messageSubscription);
        this.correlationKey.wrapBuffer(record.getCorrelationKeyBuffer());
        this.messageNameAndCorrelationKeyColumnFamily.insert(this.nameCorrelationAndElementInstanceKey, DbNil.INSTANCE);
    }

    public ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong>, DbNil> getMessageNameAndCorrelationKeyColumnFamily() {
        return this.messageNameAndCorrelationKeyColumnFamily;
    }
}

