/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_4;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DbTenantAwareKey;
import io.camunda.zeebe.engine.state.migration.to_8_4.legacy.LegacySignalSubscriptionState;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import org.agrona.DirectBuffer;

public class DbSignalSubscriptionMigrationState {
    private final LegacySignalSubscriptionState from;
    private final DbSignalSubscriptionState to;

    public DbSignalSubscriptionMigrationState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.from = new LegacySignalSubscriptionState(zeebeDb, transactionContext);
        this.to = new DbSignalSubscriptionState(zeebeDb, transactionContext);
    }

    public void migrateSignalSubscriptionStateForMultiTenancy() {
        this.to.tenantIdKey.wrapString("<default>");
        this.from.getSignalNameAndSubscriptionKeyColumnFamily().forEach((key, value) -> {
            long subscriptionKey = ((DbLong)key.second()).getValue();
            DirectBuffer signalName = ((DbString)key.first()).getBuffer();
            this.to.signalName.wrapBuffer(signalName);
            this.to.subscriptionKey.wrapLong(subscriptionKey);
            this.to.signalNameAndSubscriptionKeyColumnFamily.insert(this.to.tenantAwareSignalNameAndSubscriptionKey, (SignalSubscription)value);
            this.from.getSignalNameAndSubscriptionKeyColumnFamily().deleteExisting((DbCompositeKey<DbString, DbLong>)key);
        });
        this.from.getSubscriptionKeyAndSignalNameColumnFamily().forEach((key, dbNil) -> {
            long subscriptionKey = ((DbLong)key.first()).getValue();
            DirectBuffer signalName = ((DbString)key.second()).getBuffer();
            this.to.subscriptionKey.wrapLong(subscriptionKey);
            this.to.signalName.wrapBuffer(signalName);
            this.to.subscriptionKeyAndSignalNameColumnFamily.insert(this.to.tenantAwareSubscriptionKeyAndSignalName, DbNil.INSTANCE);
            this.from.getSubscriptionKeyAndSignalNameColumnFamily().deleteExisting((DbCompositeKey<DbLong, DbString>)key);
        });
    }

    private static final class DbSignalSubscriptionState {
        private final DbString signalName;
        private final DbLong subscriptionKey;
        private final DbString tenantIdKey;
        private final DbTenantAwareKey<DbString> tenantAwareSignalName;
        private final DbCompositeKey<DbTenantAwareKey<DbString>, DbLong> tenantAwareSignalNameAndSubscriptionKey;
        private final ColumnFamily<DbCompositeKey<DbTenantAwareKey<DbString>, DbLong>, SignalSubscription> signalNameAndSubscriptionKeyColumnFamily;
        private final SignalSubscription signalSubscription = new SignalSubscription();
        private final DbCompositeKey<DbLong, DbTenantAwareKey<DbString>> tenantAwareSubscriptionKeyAndSignalName;
        private final ColumnFamily<DbCompositeKey<DbLong, DbTenantAwareKey<DbString>>, DbNil> subscriptionKeyAndSignalNameColumnFamily;

        public DbSignalSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
            this.signalName = new DbString();
            this.subscriptionKey = new DbLong();
            this.tenantIdKey = new DbString();
            this.tenantAwareSignalName = new DbTenantAwareKey<DbString>(this.tenantIdKey, this.signalName, DbTenantAwareKey.PlacementType.PREFIX);
            this.tenantAwareSignalNameAndSubscriptionKey = new DbCompositeKey<DbTenantAwareKey<DbString>, DbLong>(this.tenantAwareSignalName, this.subscriptionKey);
            this.signalNameAndSubscriptionKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.SIGNAL_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.tenantAwareSignalNameAndSubscriptionKey, this.signalSubscription);
            this.tenantAwareSubscriptionKeyAndSignalName = new DbCompositeKey<DbLong, DbTenantAwareKey<DbString>>(this.subscriptionKey, this.tenantAwareSignalName);
            this.subscriptionKeyAndSignalNameColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.SIGNAL_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.tenantAwareSubscriptionKeyAndSignalName, DbNil.INSTANCE);
        }
    }
}

