/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_4.legacy;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbNil;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.engine.state.signal.SignalSubscription;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalSubscriptionRecord;
import org.agrona.DirectBuffer;

public class LegacySignalSubscriptionState {
    private final DbString signalName;
    private final DbLong subscriptionKey;
    private final DbCompositeKey<DbString, DbLong> signalNameAndSubscriptionKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, SignalSubscription> signalNameAndSubscriptionKeyColumnFamily;
    private final SignalSubscription signalSubscription = new SignalSubscription();
    private final DbCompositeKey<DbLong, DbString> subscriptionKeyAndSignalName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> subscriptionKeyAndSignalNameColumnFamily;

    public LegacySignalSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.signalName = new DbString();
        this.subscriptionKey = new DbLong();
        this.signalNameAndSubscriptionKey = new DbCompositeKey<DbString, DbLong>(this.signalName, this.subscriptionKey);
        this.signalNameAndSubscriptionKeyColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_SIGNAL_SUBSCRIPTION_BY_NAME_AND_KEY, transactionContext, this.signalNameAndSubscriptionKey, this.signalSubscription);
        this.subscriptionKeyAndSignalName = new DbCompositeKey<DbLong, DbString>(this.subscriptionKey, this.signalName);
        this.subscriptionKeyAndSignalNameColumnFamily = zeebeDb.createColumnFamily(ZbColumnFamilies.DEPRECATED_SIGNAL_SUBSCRIPTION_BY_KEY_AND_NAME, transactionContext, this.subscriptionKeyAndSignalName, DbNil.INSTANCE);
    }

    public void put(long key, SignalSubscriptionRecord subscription) {
        this.signalSubscription.setKey(key).setRecord(subscription);
        this.wrapSubscriptionKeys(subscription);
        this.signalNameAndSubscriptionKeyColumnFamily.upsert(this.signalNameAndSubscriptionKey, this.signalSubscription);
        this.subscriptionKeyAndSignalNameColumnFamily.upsert(this.subscriptionKeyAndSignalName, DbNil.INSTANCE);
    }

    public ColumnFamily<DbCompositeKey<DbString, DbLong>, SignalSubscription> getSignalNameAndSubscriptionKeyColumnFamily() {
        return this.signalNameAndSubscriptionKeyColumnFamily;
    }

    public ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> getSubscriptionKeyAndSignalNameColumnFamily() {
        return this.subscriptionKeyAndSignalNameColumnFamily;
    }

    private void wrapSubscriptionKeys(SignalSubscriptionRecord subscription) {
        long key = subscription.getSubscriptionKey();
        this.wrapSubscriptionKeys(key, subscription.getSignalNameBuffer());
    }

    private void wrapSubscriptionKeys(long key, DirectBuffer signalName) {
        this.subscriptionKey.wrapLong(key);
        this.signalName.wrapBuffer(signalName);
    }
}

