/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.engine.state.migration.to_8_5.corrections;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbBytes;
import io.camunda.zeebe.db.impl.DbCompositeKey;
import io.camunda.zeebe.db.impl.DbInt;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.ZeebeDbConstants;
import io.camunda.zeebe.engine.state.migration.DbMigratorImpl;
import io.camunda.zeebe.engine.state.migration.to_8_5.corrections.ColumnFamilyCorrectionException;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ColumnFamily48Corrector {
    private static final Logger LOG = LoggerFactory.getLogger(DbMigratorImpl.class.getPackageName());
    private static final ZbColumnFamilies CF_UNDER_RECOVERY = ZbColumnFamilies.DEPRECATED_DMN_DECISION_KEY_BY_DECISION_ID_AND_VERSION;
    private static final ZbColumnFamilies CF_POSSIBLE_TARGET = ZbColumnFamilies.MESSAGE_STATS;
    private final ColumnFamily<DbBytes, DbBytes> recoveryDmnDecisionKeyByDecisionIdAndVersion;
    private final DbString decisionId = new DbString();
    private final DbInt decisionVersion = new DbInt();
    private final ColumnFamily<DbString, DbLong> messageStatsColumnFamily;
    private final DbString messagesDeadlineCountKey;
    private final DbLong messagesDeadlineCount;

    public ColumnFamily48Corrector(ZeebeDb<ZbColumnFamilies> zeebeDb, TransactionContext transactionContext) {
        this.recoveryDmnDecisionKeyByDecisionIdAndVersion = zeebeDb.createColumnFamily(CF_UNDER_RECOVERY, transactionContext, new DbBytes(), new DbBytes());
        this.messagesDeadlineCountKey = new DbString();
        this.messagesDeadlineCount = new DbLong();
        this.messageStatsColumnFamily = zeebeDb.createColumnFamily(CF_POSSIBLE_TARGET, transactionContext, this.messagesDeadlineCountKey, this.messagesDeadlineCount);
    }

    public void correctColumnFamilyPrefix() {
        this.recoveryDmnDecisionKeyByDecisionIdAndVersion.forEach((key, value) -> {
            if (!this.isKeyWithExpectedLength((DbBytes)key)) {
                LOG.trace("Found invalid key [{}] (incorrect key length) in column family [{}] {}", key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name());
                this.tryMoveDataToMessageStatsColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            try {
                DbCompositeKey<DbString, DbInt> dmnDecisionKeyByDecisionIdAndVersion = new DbCompositeKey<DbString, DbInt>(this.decisionId, this.decisionVersion);
                dmnDecisionKeyByDecisionIdAndVersion.wrap(key.getDirectBuffer(), 0, key.getLength());
            }
            catch (Exception e) {
                LOG.trace("Found invalid key [{}] (unable to read key) in column family [{}] {}", key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name());
                this.tryMoveDataToMessageStatsColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            DbLong decisionKey = new DbLong();
            try {
                decisionKey.wrap(value.getDirectBuffer(), 0, value.getLength());
            }
            catch (Exception e) {
                LOG.trace("Found invalid value [{}] (unable to read value) in column family [{}] {}", value, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name());
                this.tryMoveDataToMessageStatsColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            if (value.getLength() != decisionKey.getLength()) {
                LOG.trace("Found invalid value [{}] (incorrect value length) in column family [{}] {}", value, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name());
                this.tryMoveDataToMessageStatsColumnFamily((DbBytes)key, (DbBytes)value);
                return;
            }
            LOG.trace("Found valid decision key entry with key[{}] in recovery column family", key);
        });
    }

    private boolean isKeyWithExpectedLength(DbBytes key) {
        int stringLength = key.getDirectBuffer().getInt(0, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        return key.getLength() == 4 + stringLength + 4;
    }

    private void tryMoveDataToMessageStatsColumnFamily(DbBytes key, DbBytes value) {
        try {
            this.messagesDeadlineCountKey.wrap(key.getDirectBuffer(), 0, key.getLength());
            this.messagesDeadlineCount.wrap(value.getDirectBuffer(), 0, value.getLength());
        }
        catch (Exception e) {
            String reason = "unexpected data in column family";
            throw new ColumnFamilyCorrectionException("unexpected data in column family", key, value, CF_UNDER_RECOVERY, e);
        }
        if (key.getLength() != this.messagesDeadlineCountKey.getLength()) {
            throw new ColumnFamilyCorrectionException("incorrect key length", key, value, CF_UNDER_RECOVERY, null);
        }
        if (value.getLength() != this.messagesDeadlineCount.getLength()) {
            throw new ColumnFamilyCorrectionException("incorrect value length", key, value, CF_UNDER_RECOVERY, null);
        }
        if (!"deadline_message_count".equals(this.messagesDeadlineCountKey.toString())) {
            throw new ColumnFamilyCorrectionException("incorrect key value", key, value, CF_UNDER_RECOVERY, null);
        }
        long valueToMove = this.messagesDeadlineCount.getValue();
        DbLong currentCount = this.messageStatsColumnFamily.get(this.messagesDeadlineCountKey);
        if (currentCount != null) {
            LOG.trace("Found existing message stats entry with key [{}] and value [{}]", (Object)key, (Object)currentCount);
            this.messagesDeadlineCount.wrapLong(valueToMove + currentCount.getValue());
        }
        this.moveEntryFromRecoveryColumnFamilyToMessageStatsColumnFamily(key, this.messagesDeadlineCountKey, this.messagesDeadlineCount);
    }

    private void moveEntryFromRecoveryColumnFamilyToMessageStatsColumnFamily(DbBytes key, DbString messagesDeadlineCountKey, DbLong messagesDeadlineCount) {
        LOG.debug("Copying entry with key[{}] and value [{}] from column family [{}] {} to column family [{}] {}", key, messagesDeadlineCount, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name(), CF_POSSIBLE_TARGET.ordinal(), CF_POSSIBLE_TARGET.name());
        this.messageStatsColumnFamily.upsert(messagesDeadlineCountKey, messagesDeadlineCount);
        this.deleteEntryFromRecoveryColumnFamily(key);
    }

    private void deleteEntryFromRecoveryColumnFamily(DbBytes key) {
        LOG.debug("Deleting entry with key[{}] from column family [{}] {}", key, CF_UNDER_RECOVERY.ordinal(), CF_UNDER_RECOVERY.name());
        this.recoveryDmnDecisionKeyByDecisionIdAndVersion.deleteExisting(key);
    }
}

