/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.feel.impl;

import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackToken;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.camunda.feel.context.CustomContext;
import org.camunda.feel.context.VariableProvider;
import scala.Option;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.immutable.Map;
import scala.collection.mutable.Builder;

public class MessagePackContext
extends CustomContext {
    public final DirectBuffer messagePackMap;
    private final VariableProvider variableProvider;

    public MessagePackContext(MsgPackReader reader, int bufferOffset, int size) {
        Map<String, Span> valueSpans = this.readValueSpans(reader, bufferOffset, size);
        this.messagePackMap = BufferUtil.cloneBuffer(reader.getBuffer(), bufferOffset, reader.getOffset() - bufferOffset);
        this.variableProvider = new MessagePackMapVariableProvider(this.messagePackMap, valueSpans);
    }

    @Override
    public VariableProvider variableProvider() {
        return this.variableProvider;
    }

    private Map<String, Span> readValueSpans(MsgPackReader reader, int bufferOffset, int size) {
        Builder spans = Map.newBuilder();
        spans.sizeHint(size);
        for (int i = 0; i < size; ++i) {
            MsgPackToken keyToken = reader.readToken();
            DirectBuffer keyBuffer = keyToken.getValueBuffer();
            String key = BufferUtil.bufferAsString(keyBuffer);
            int valueOffset = reader.getOffset();
            reader.skipValue();
            int valueLength = reader.getOffset() - valueOffset;
            spans.addOne(new Tuple2<String, Span>(key, new Span(valueOffset - bufferOffset, valueLength)));
        }
        return spans.result();
    }

    private static final class MessagePackMapVariableProvider
    implements VariableProvider {
        private final DirectBuffer entries;
        private final DirectBuffer resultView = new UnsafeBuffer();
        private final Map<String, Span> valueSpans;

        private MessagePackMapVariableProvider(DirectBuffer entries, Map<String, Span> valueSpans) {
            this.entries = entries;
            this.valueSpans = valueSpans;
        }

        @Override
        public Option<Object> getVariable(String name) {
            return this.valueSpans.get(name).map(span -> {
                this.resultView.wrap(this.entries, span.offset(), span.length());
                return this.resultView;
            });
        }

        @Override
        public Iterable<String> keys() {
            return this.valueSpans.keySet();
        }

        @Override
        public Map<String, Object> getVariables() {
            Builder clonedMap = Map.newBuilder();
            this.valueSpans.foreach(entry -> clonedMap.addOne(new Tuple2<String, DirectBuffer>((String)entry._1(), BufferUtil.cloneBuffer(this.entries, ((Span)entry._2()).offset(), ((Span)entry._2()).length()))));
            return clonedMap.result();
        }
    }

    record Span(int offset, int length) {
    }
}

