/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.feel.impl;

import io.camunda.zeebe.feel.impl.Loggers;
import io.camunda.zeebe.feel.impl.MessagePackContext;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackToken;
import io.camunda.zeebe.msgpack.spec.MsgPackType;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.camunda.feel.impl.JavaValueMapper;
import org.camunda.feel.syntaxtree.Val;
import org.camunda.feel.syntaxtree.ValBoolean;
import org.camunda.feel.syntaxtree.ValContext;
import org.camunda.feel.syntaxtree.ValList;
import org.camunda.feel.syntaxtree.ValNull$;
import org.camunda.feel.syntaxtree.ValNumber;
import org.camunda.feel.syntaxtree.ValString;
import scala.Function1;
import scala.Option;
import scala.jdk.javaapi.CollectionConverters;

public final class MessagePackValueMapper
extends JavaValueMapper {
    private final MsgPackReader msgPackReader = new MsgPackReader();

    private Val readNext() {
        int offset = this.msgPackReader.getOffset();
        MsgPackToken token = this.msgPackReader.readToken();
        return this.read(token, offset);
    }

    private Val read(MsgPackToken token, int offset) {
        return switch (token.getType()) {
            case MsgPackType.NIL -> ValNull$.MODULE$;
            case MsgPackType.INTEGER -> new ValNumber(new scala.math.BigDecimal(new BigDecimal(token.getIntegerValue())));
            case MsgPackType.BOOLEAN -> new ValBoolean(token.getBooleanValue());
            case MsgPackType.FLOAT -> new ValNumber(new scala.math.BigDecimal(BigDecimal.valueOf(token.getFloatValue())));
            case MsgPackType.ARRAY -> {
                int size = token.getSize();
                ArrayList<Val> items = new ArrayList<Val>(size);
                for (int i = 0; i < size; ++i) {
                    items.add(this.readNext());
                }
                yield new ValList(CollectionConverters.asScala(items).toList());
            }
            case MsgPackType.MAP -> new ValContext(new MessagePackContext(this.msgPackReader, offset, token.getSize()));
            case MsgPackType.STRING -> new ValString(BufferUtil.bufferAsString(token.getValueBuffer()));
            default -> {
                Loggers.LOGGER.warn("No MessagePack to FEEL transformation for type '{}'. Using 'null' instead.", (Object)token.getType());
                yield ValNull$.MODULE$;
            }
        };
    }

    @Override
    public Option<Object> unpackVal(Val value, Function1<Val, Object> innerValueMapper) {
        return Option.apply(value);
    }

    @Override
    public Option<Val> toVal(Object x, Function1<Object, Val> innerValueMapper) {
        if (x instanceof DirectBuffer) {
            DirectBuffer buffer = (DirectBuffer)x;
            this.msgPackReader.wrap(buffer, 0, buffer.capacity());
            return Option.apply(this.readNext());
        }
        return Option.empty();
    }
}

