/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limiter;
import com.netflix.concurrency.limits.limiter.AbstractLimiter;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import java.util.Optional;

final class AppendLimiter
extends AbstractLimiter<Void> {
    private final LogStreamMetrics metrics;

    private AppendLimiter(AbstractLimiter.Builder<?> builder, LogStreamMetrics metrics) {
        super(builder);
        this.metrics = metrics;
        metrics.setInflightLimit(this.getLimit());
    }

    public static AppenderLimiterBuilder builder() {
        return new AppenderLimiterBuilder();
    }

    @Override
    public Optional<Limiter.Listener> acquire(Void context) {
        if (this.getInflight() >= this.getLimit()) {
            return this.createRejectedListener();
        }
        return Optional.of(this.createListener());
    }

    @Override
    protected void onNewLimit(int newLimit) {
        super.onNewLimit(newLimit);
        this.metrics.setInflightLimit(newLimit);
    }

    static final class AppenderLimiterBuilder
    extends AbstractLimiter.Builder<AppenderLimiterBuilder> {
        private LogStreamMetrics metrics;

        AppenderLimiterBuilder() {
        }

        public AppenderLimiterBuilder metrics(LogStreamMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public AppendLimiter build() {
            return new AppendLimiter(this, this.metrics);
        }

        @Override
        protected AppenderLimiterBuilder self() {
            return this;
        }
    }
}

