/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.Limiter;
import io.camunda.zeebe.logstreams.impl.LogStreamMetrics;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.prometheus.client.Histogram;

public final class InFlightAppend
implements LogStorage.AppendListener {
    private final Limiter.Listener limiter;
    private final LogStreamMetrics metrics;
    private Histogram.Timer writeTimer;
    private Histogram.Timer commitTimer;
    private long position;

    public InFlightAppend(Limiter.Listener limiter, LogStreamMetrics metrics) {
        this.limiter = limiter;
        this.metrics = metrics;
    }

    @Override
    public void onWrite(long address) {
        this.writeTimer.close();
        this.metrics.setLastWrittenPosition(this.position);
    }

    @Override
    public void onCommit(long address) {
        this.metrics.decreaseInflight();
        this.metrics.setLastCommittedPosition(this.position);
        if (this.commitTimer != null) {
            this.commitTimer.close();
        }
        this.limiter.onSuccess();
    }

    public InFlightAppend start(long position) {
        this.position = position;
        this.writeTimer = this.metrics.startWriteTimer();
        this.commitTimer = this.metrics.startCommitTimer();
        this.metrics.increaseInflight();
        this.metrics.increaseTriedAppends();
        return this;
    }

    public void discard() {
        this.limiter.onIgnore();
    }
}

