/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.impl.flowcontrol;

import com.netflix.concurrency.limits.limit.AbstractLimit;
import com.netflix.concurrency.limits.limit.VegasLimit;

final class VegasConfig {
    private final int initialLimit = 1024;
    private final int maxConcurrency = 32768;
    private final double alphaLimit = 0.7;
    private final double betaLimit = 0.95;

    VegasConfig() {
    }

    public int getInitialLimit() {
        return 1024;
    }

    public int getMaxConcurrency() {
        return 32768;
    }

    public double getAlphaLimit() {
        return 0.7;
    }

    public double getBetaLimit() {
        return 0.95;
    }

    public AbstractLimit get() {
        return VegasLimit.newBuilder().alpha(limit -> Math.max(3, (int)((double)limit.intValue() * 0.7))).beta(limit -> Math.max(6, (int)((double)limit.intValue() * 0.95))).initialLimit(1024).maxConcurrency(32768).increase(limit -> limit + Math.log(limit)).decrease(limit -> limit - Math.log(limit)).build();
    }

    public String toString() {
        return "Vegas{initialLimit=1024, maxConcurrency=32768, alphaLimit=0.7, betaLimit=0.95}";
    }
}

