/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.logstreams.storage;

import io.camunda.zeebe.logstreams.storage.LogStorageReader;
import io.camunda.zeebe.util.buffer.BufferWriter;
import io.camunda.zeebe.util.buffer.DirectBufferWriter;
import java.nio.ByteBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public interface LogStorage {
    public LogStorageReader newReader();

    public void append(long var1, long var3, BufferWriter var5, AppendListener var6);

    default public void append(long lowestPosition, long highestPosition, ByteBuffer blockBuffer, AppendListener listener) {
        this.append(lowestPosition, highestPosition, new DirectBufferWriter().wrap(new UnsafeBuffer(blockBuffer)), listener);
    }

    public void addCommitListener(CommitListener var1);

    public void removeCommitListener(CommitListener var1);

    public static interface AppendListener {
        default public void onWrite(long address) {
        }

        default public void onCommit(long address) {
        }
    }

    public static interface CommitListener {
        public void onCommit();
    }
}

