/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.builder;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.builder.AbstractProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.camunda.zeebe.model.bpmn.builder.ExecutionListenerBuilder;
import io.camunda.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.StartEventBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeExecutionListenersBuilder;
import io.camunda.zeebe.model.bpmn.builder.ZeebeExecutionListenersBuilderImpl;
import io.camunda.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.instance.StartEvent;
import io.camunda.zeebe.model.bpmn.instance.SubProcess;
import io.camunda.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import io.camunda.zeebe.model.bpmn.instance.dc.Bounds;
import java.util.Collection;
import java.util.function.Consumer;

public class ProcessBuilder
extends AbstractProcessBuilder<ProcessBuilder>
implements ZeebeExecutionListenersBuilder<ProcessBuilder> {
    private final ZeebeExecutionListenersBuilder<ProcessBuilder> zeebeExecutionListenersBuilder;

    public ProcessBuilder(BpmnModelInstance modelInstance, Process process) {
        super(modelInstance, process, ProcessBuilder.class);
        this.zeebeExecutionListenersBuilder = new ZeebeExecutionListenersBuilderImpl<ProcessBuilder>((ProcessBuilder)this.myself);
    }

    public StartEventBuilder startEvent() {
        return this.startEvent(null);
    }

    public StartEventBuilder startEvent(String id) {
        StartEvent start = this.createChild(StartEvent.class, id);
        BpmnShape bpmnShape = this.createBpmnShape(start);
        this.setCoordinates(bpmnShape);
        return start.builder();
    }

    public EventSubProcessBuilder eventSubProcess() {
        return this.eventSubProcess(null);
    }

    public EventSubProcessBuilder eventSubProcess(String id) {
        SubProcess subProcess = this.createChild(SubProcess.class, id);
        subProcess.setTriggeredByEvent(true);
        BpmnShape targetBpmnShape = this.createBpmnShape(subProcess);
        this.setEventCoordinates(targetBpmnShape);
        this.resizeBpmnShape(targetBpmnShape);
        return new EventSubProcessBuilder(this.modelInstance, subProcess);
    }

    public ProcessBuilder eventSubProcess(String id, Consumer<EventSubProcessBuilder> consumer) {
        EventSubProcessBuilder builder = this.eventSubProcess(id);
        consumer.accept(builder);
        return this;
    }

    public IntermediateCatchEventBuilder linkCatchEvent() {
        return this.linkCatchEvent(null);
    }

    public IntermediateCatchEventBuilder linkCatchEvent(String id) {
        IntermediateCatchEvent catchEvent = this.createChild(IntermediateCatchEvent.class, id);
        BpmnShape bpmnShape = this.createBpmnShape(catchEvent);
        this.setEventCoordinates(bpmnShape);
        this.resizeBpmnShape(bpmnShape);
        return catchEvent.builder();
    }

    @Override
    protected void setCoordinates(BpmnShape targetBpmnShape) {
        Bounds bounds = targetBpmnShape.getBounds();
        bounds.setX(100.0);
        bounds.setY(64.0 + this.getLowestHeight());
    }

    protected void setEventCoordinates(BpmnShape targetBpmnShape) {
        Bounds targetBounds = targetBpmnShape.getBounds();
        double yCoord = this.getLowestHeight() + 50.0;
        double xCoord = 100.0;
        targetBounds.setY(yCoord);
        targetBounds.setX(100.0);
    }

    private double getLowestHeight() {
        double lowestheight = 0.0;
        Collection<BpmnShape> allShapes = this.modelInstance.getModelElementsByType(BpmnShape.class);
        for (BpmnShape shape : allShapes) {
            Bounds bounds = shape.getBounds();
            double bottom = bounds.getY() + bounds.getHeight();
            if (!(bottom > lowestheight)) continue;
            lowestheight = bottom;
        }
        return lowestheight;
    }

    @Override
    public ProcessBuilder zeebeStartExecutionListener(String type, String retries) {
        return this.zeebeExecutionListenersBuilder.zeebeStartExecutionListener(type, retries);
    }

    @Override
    public ProcessBuilder zeebeStartExecutionListener(String type) {
        return this.zeebeExecutionListenersBuilder.zeebeStartExecutionListener(type);
    }

    @Override
    public ProcessBuilder zeebeEndExecutionListener(String type, String retries) {
        return this.zeebeExecutionListenersBuilder.zeebeEndExecutionListener(type, retries);
    }

    @Override
    public ProcessBuilder zeebeEndExecutionListener(String type) {
        return this.zeebeExecutionListenersBuilder.zeebeEndExecutionListener(type);
    }

    @Override
    public ProcessBuilder zeebeExecutionListener(Consumer<ExecutionListenerBuilder> executionListenerBuilderConsumer) {
        return this.zeebeExecutionListenersBuilder.zeebeExecutionListener(executionListenerBuilderConsumer);
    }
}

