/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.traversal;

import io.camunda.zeebe.model.bpmn.BpmnModelInstance;
import io.camunda.zeebe.model.bpmn.impl.BpmnModelInstanceImpl;
import io.camunda.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.camunda.zeebe.model.bpmn.instance.Definitions;
import io.camunda.zeebe.model.bpmn.instance.Process;
import io.camunda.zeebe.model.bpmn.traversal.ModelElementVisitor;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelWalker {
    private static final Logger LOG = LoggerFactory.getLogger(ModelWalker.class);
    private final BpmnModelInstanceImpl modelInstance;
    private final Deque<BpmnModelElementInstance> elementsToVisit = new LinkedList<BpmnModelElementInstance>();

    public ModelWalker(BpmnModelInstance modelInstance) {
        this.modelInstance = (BpmnModelInstanceImpl)modelInstance;
    }

    public void walk(ModelElementVisitor visitor) {
        BpmnModelElementInstance currentElement;
        Definitions rootElement = this.modelInstance.getDefinitions();
        this.elementsToVisit.add(rootElement);
        while ((currentElement = this.elementsToVisit.poll()) != null) {
            if (this.isNonExecutableProcess(currentElement)) continue;
            visitor.visit(currentElement);
            Collection<ModelElementInstance> children = this.getChildElements(currentElement);
            children.forEach(c -> {
                if (c instanceof BpmnModelElementInstance) {
                    this.elementsToVisit.addFirst((BpmnModelElementInstance)c);
                } else {
                    ModelElementType elementType = c.getElementType();
                    LOG.debug("Ignoring unknown BPMN element '{}:{}'", (Object)elementType.getTypeNamespace(), (Object)elementType.getTypeName());
                }
            });
        }
    }

    private Collection<ModelElementInstance> getChildElements(BpmnModelElementInstance element) {
        return ModelUtil.getModelElementCollection(element.getDomElement().getChildElements(), this.modelInstance);
    }

    private boolean isNonExecutableProcess(BpmnModelElementInstance element) {
        if (element instanceof Process) {
            Process process = (Process)element;
            return !process.isExecutable();
        }
        return false;
    }
}

