/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.util.time;

import io.camunda.zeebe.model.bpmn.util.time.Interval;
import io.camunda.zeebe.model.bpmn.util.time.Timer;
import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;

public class TimeDateTimer
implements Timer {
    private final Interval interval;

    public TimeDateTimer(Interval interval) {
        this.interval = interval;
    }

    public TimeDateTimer(ZonedDateTime dateTime3) {
        this(new Interval(Period.ZERO, Duration.ofMillis(dateTime3.toInstant().toEpochMilli())));
    }

    public static TimeDateTimer parse(String timeDate) {
        return new TimeDateTimer(ZonedDateTime.parse(timeDate));
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public int getRepetitions() {
        return 1;
    }

    @Override
    public long getDueDate(long fromEpochMillis) {
        return this.getInterval().toEpochMilli(0L);
    }
}

