/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.model.bpmn.validation.zeebe;

import io.camunda.zeebe.model.bpmn.instance.CatchEvent;
import io.camunda.zeebe.model.bpmn.instance.EndEvent;
import io.camunda.zeebe.model.bpmn.instance.Escalation;
import io.camunda.zeebe.model.bpmn.instance.EscalationEventDefinition;
import io.camunda.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class EscalationEventDefinitionValidator
implements ModelElementValidator<EscalationEventDefinition> {
    private static final String ZEEBE_EXPRESSION_PREFIX = "=";

    @Override
    public Class<EscalationEventDefinition> getElementType() {
        return EscalationEventDefinition.class;
    }

    @Override
    public void validate(EscalationEventDefinition element, ValidationResultCollector validationResultCollector) {
        String escalationCode;
        Escalation escalation = element.getEscalation();
        ModelElementInstance parentElement = element.getParentElement();
        if (this.isEscalationThrowEvent(parentElement) && escalation == null) {
            validationResultCollector.addError(0, "Must reference an escalation");
        }
        if (parentElement instanceof CatchEvent && escalation != null && (escalationCode = escalation.getEscalationCode()) != null && escalationCode.startsWith(ZEEBE_EXPRESSION_PREFIX)) {
            validationResultCollector.addError(0, "The escalationCode of the escalation catch event is not allowed to be an expression");
        }
    }

    private boolean isEscalationThrowEvent(ModelElementInstance parentElement) {
        return parentElement instanceof IntermediateThrowEvent || parentElement instanceof EndEvent;
    }
}

