/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.property;

import io.camunda.zeebe.msgpack.property.BaseProperty;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.util.StringUtil;
import org.agrona.DirectBuffer;

public final class StringProperty
extends BaseProperty<StringValue> {
    public StringProperty(String key) {
        super(key, new StringValue());
    }

    public StringProperty(String key, String defaultValue) {
        super(key, new StringValue(), new StringValue(defaultValue));
    }

    public DirectBuffer getValue() {
        return ((StringValue)this.resolveValue()).getValue();
    }

    public void setValue(String value) {
        ((StringValue)this.value).wrap(StringUtil.getBytes(value));
        this.isSet = true;
    }

    public void setValue(DirectBuffer buffer) {
        this.setValue(buffer, 0, buffer.capacity());
    }

    public void setValue(DirectBuffer buffer, int offset, int length) {
        ((StringValue)this.value).wrap(buffer, offset, length);
        this.isSet = true;
    }
}

