/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.msgpack.value;

import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.msgpack.value.BaseValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.function.Supplier;
import org.agrona.collections.CollectionUtil;

public final class ArrayValue<T extends BaseValue>
extends BaseValue
implements Iterable<T>,
RandomAccess {
    private final List<T> items;
    private final Supplier<T> valueFactory;

    public ArrayValue(Supplier<T> valueFactory) {
        this.valueFactory = valueFactory;
        this.items = new ArrayList<T>();
    }

    @Override
    public void reset() {
        this.items.clear();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        builder.append("[");
        for (int i = 0; i < this.items.size(); ++i) {
            if (i > 0) {
                builder.append(",");
            }
            ((BaseValue)this.items.get(i)).writeJSON(builder);
        }
        builder.append("]");
    }

    @Override
    public void write(MsgPackWriter writer) {
        writer.writeArrayHeader(this.items.size());
        for (int i = 0; i < this.items.size(); ++i) {
            ((BaseValue)this.items.get(i)).write(writer);
        }
    }

    @Override
    public void read(MsgPackReader reader) {
        this.reset();
        int size = reader.readArrayHeader();
        for (int i = 0; i < size; ++i) {
            BaseValue value = (BaseValue)this.valueFactory.get();
            value.read(reader);
            this.items.add(i, value);
        }
    }

    @Override
    public int getEncodedLength() {
        return MsgPackWriter.getEncodedArrayHeaderLenght(this.items.size()) + CollectionUtil.sum(this.items, BaseValue::getEncodedLength);
    }

    @Override
    public Iterator<T> iterator() {
        return this.items.iterator();
    }

    public int hashCode() {
        return Objects.hash(this.items);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArrayValue)) {
            return false;
        }
        ArrayValue that = (ArrayValue)o;
        return this.items.equals(that.items);
    }

    public T add() {
        BaseValue item = (BaseValue)this.valueFactory.get();
        this.items.add(item);
        return (T)item;
    }

    public T add(int index) {
        BaseValue item = (BaseValue)this.valueFactory.get();
        this.items.add(index, item);
        return (T)item;
    }

    public T get(int index) {
        return (T)((BaseValue)this.items.get(index));
    }

    public T remove(int index) {
        return (T)((BaseValue)this.items.remove(index));
    }

    public int size() {
        return this.items.size();
    }
}

