/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine;

import io.camunda.zeebe.logstreams.log.LogStreamReader;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.process.test.api.RecordStreamSource;
import io.camunda.zeebe.protocol.impl.record.CopiedRecord;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.stream.impl.TypedEventRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class RecordStreamSourceImpl
implements RecordStreamSource {
    private final LogStreamReader logStreamReader;
    private final int partitionId;
    private final List<Record<?>> records = new ArrayList();
    private volatile long lastPosition = -1L;

    public RecordStreamSourceImpl(LogStreamReader logStreamReader, int partitionId) {
        this.logStreamReader = logStreamReader;
        this.partitionId = partitionId;
    }

    @Override
    public Iterable<Record<?>> getRecords() {
        this.updateWithNewRecords();
        return Collections.unmodifiableList(this.records);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateWithNewRecords() {
        LogStreamReader logStreamReader = this.logStreamReader;
        synchronized (logStreamReader) {
            if (this.lastPosition < 0L) {
                this.logStreamReader.seekToFirstEvent();
            } else {
                this.logStreamReader.seekToNextEvent(this.lastPosition);
            }
            while (this.logStreamReader.hasNext()) {
                LoggedEvent event = (LoggedEvent)this.logStreamReader.next();
                CopiedRecord<UnifiedRecordValue> record = this.mapToRecord(event);
                this.records.add(record);
                this.lastPosition = event.getPosition();
            }
        }
    }

    private CopiedRecord<UnifiedRecordValue> mapToRecord(LoggedEvent event) {
        UnifiedRecordValue value;
        RecordMetadata metadata = new RecordMetadata();
        event.readMetadata(metadata);
        try {
            value = TypedEventRegistry.EVENT_REGISTRY.get((Object)metadata.getValueType()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        event.readValue(value);
        return new CopiedRecord<UnifiedRecordValue>(value, metadata, event.getKey(), this.partitionId, event.getPosition(), event.getSourceEventPosition(), event.getTimestamp());
    }
}

