/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.process.test.engine.agent;

import io.camunda.zeebe.process.test.api.ZeebeTestEngine;
import io.camunda.zeebe.process.test.engine.EngineFactory;
import io.camunda.zeebe.process.test.engine.agent.AgentProperties;
import io.camunda.zeebe.process.test.engine.agent.RecordStreamSourceWrapper;
import io.camunda.zeebe.process.test.engine.protocol.EngineControlGrpc;
import io.camunda.zeebe.process.test.engine.protocol.EngineControlOuterClass;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeoutException;

public final class EngineControlImpl
extends EngineControlGrpc.EngineControlImplBase {
    private ZeebeTestEngine engine;
    private RecordStreamSourceWrapper recordStreamSource;

    public EngineControlImpl(ZeebeTestEngine engine) {
        this.engine = engine;
        this.recordStreamSource = new RecordStreamSourceWrapper(engine.getRecordStreamSource());
    }

    @Override
    public void startEngine(EngineControlOuterClass.StartEngineRequest request, StreamObserver<EngineControlOuterClass.StartEngineResponse> responseObserver) {
        this.engine.start();
        this.recordStreamSource = new RecordStreamSourceWrapper(this.engine.getRecordStreamSource());
        EngineControlOuterClass.StartEngineResponse response = EngineControlOuterClass.StartEngineResponse.newBuilder().build();
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    @Override
    public void stopEngine(EngineControlOuterClass.StopEngineRequest request, StreamObserver<EngineControlOuterClass.StopEngineResponse> responseObserver) {
        this.engine.stop();
        EngineControlOuterClass.StopEngineResponse response = EngineControlOuterClass.StopEngineResponse.newBuilder().build();
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    @Override
    public void resetEngine(EngineControlOuterClass.ResetEngineRequest request, StreamObserver<EngineControlOuterClass.ResetEngineResponse> responseObserver) {
        this.engine.stop();
        this.engine = EngineFactory.create(AgentProperties.getGatewayPort());
        EngineControlOuterClass.ResetEngineResponse response = EngineControlOuterClass.ResetEngineResponse.newBuilder().build();
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    @Override
    public void increaseTime(EngineControlOuterClass.IncreaseTimeRequest request, StreamObserver<EngineControlOuterClass.IncreaseTimeResponse> responseObserver) {
        this.engine.increaseTime(Duration.ofMillis(request.getMilliseconds()));
        EngineControlOuterClass.IncreaseTimeResponse response = EngineControlOuterClass.IncreaseTimeResponse.newBuilder().build();
        responseObserver.onNext(response);
        responseObserver.onCompleted();
    }

    @Override
    public void waitForIdleState(EngineControlOuterClass.WaitForIdleStateRequest request, StreamObserver<EngineControlOuterClass.WaitForIdleStateResponse> responseObserver) {
        try {
            this.engine.waitForIdleState(Duration.ofMillis(request.getTimeout()));
            EngineControlOuterClass.WaitForIdleStateResponse response = EngineControlOuterClass.WaitForIdleStateResponse.newBuilder().build();
            responseObserver.onNext(response);
            responseObserver.onCompleted();
        }
        catch (InterruptedException e) {
            responseObserver.onError(Status.INTERNAL.withCause(e).asException());
        }
        catch (TimeoutException e) {
            responseObserver.onError(Status.DEADLINE_EXCEEDED.withDescription(String.format("Engine has not reached idle state within specified timeout of %d ms", request.getTimeout())).withCause(e).asException());
        }
    }

    @Override
    public void waitForBusyState(EngineControlOuterClass.WaitForBusyStateRequest request, StreamObserver<EngineControlOuterClass.WaitForBusyStateResponse> responseObserver) {
        try {
            this.engine.waitForBusyState(Duration.ofMillis(request.getTimeout()));
            EngineControlOuterClass.WaitForBusyStateResponse response = EngineControlOuterClass.WaitForBusyStateResponse.newBuilder().build();
            responseObserver.onNext(response);
            responseObserver.onCompleted();
        }
        catch (InterruptedException e) {
            responseObserver.onError(Status.INTERNAL.withCause(e).asException());
        }
        catch (TimeoutException e) {
            responseObserver.onError(Status.DEADLINE_EXCEEDED.withDescription(String.format("Engine has not started processing within specified timeout of %d ms", request.getTimeout())).withCause(e).asException());
        }
    }

    @Override
    public void getRecords(EngineControlOuterClass.GetRecordsRequest request, StreamObserver<EngineControlOuterClass.RecordResponse> responseObserver) {
        List<String> mappedRecords = this.recordStreamSource.getMappedRecords();
        mappedRecords.forEach(record -> responseObserver.onNext(EngineControlOuterClass.RecordResponse.newBuilder().setRecordJson((String)record).build()));
        responseObserver.onCompleted();
    }
}

