/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record;

import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.protocol.impl.encoding.AuthInfo;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.util.StringUtil;
import java.util.Map;
import org.agrona.concurrent.UnsafeBuffer;

public final class CopiedRecord<T extends UnifiedRecordValue>
implements Record<T> {
    private final ValueType valueType;
    private final T recordValue;
    private final long key;
    private final long position;
    private final long sourcePosition;
    private final long timestamp;
    private final RecordType recordType;
    private final Intent intent;
    private final int partitionId;
    private final RejectionType rejectionType;
    private final String rejectionReason;
    private final String brokerVersion;
    private final AuthInfo authorization;
    private final int recordVersion;

    public CopiedRecord(T recordValue, RecordMetadata metadata, long key, int partitionId, long position, long sourcePosition, long timestamp) {
        this.recordValue = recordValue;
        this.key = key;
        this.position = position;
        this.sourcePosition = sourcePosition;
        this.timestamp = timestamp;
        this.intent = metadata.getIntent();
        this.recordType = metadata.getRecordType();
        this.partitionId = partitionId;
        this.rejectionType = metadata.getRejectionType();
        this.rejectionReason = metadata.getRejectionReason();
        this.valueType = metadata.getValueType();
        this.brokerVersion = metadata.getBrokerVersion().toString();
        this.authorization = metadata.getAuthorization();
        this.recordVersion = metadata.getRecordVersion();
    }

    private CopiedRecord(CopiedRecord<T> copiedRecord) {
        RecordValue value = copiedRecord.getValue();
        byte[] bytes = new byte[((UnifiedRecordValue)value).getLength()];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        ((UnpackedObject)((Object)value)).write(buffer, 0);
        Class<?> recordValueClass = value.getClass();
        try {
            UnifiedRecordValue recordValue = (UnifiedRecordValue)recordValueClass.newInstance();
            recordValue.wrap(buffer);
            this.recordValue = recordValue;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Expected to instantiate %s, but has no default ctor.", recordValueClass.getName()), e);
        }
        this.key = copiedRecord.key;
        this.position = copiedRecord.position;
        this.sourcePosition = copiedRecord.sourcePosition;
        this.timestamp = copiedRecord.timestamp;
        this.intent = copiedRecord.intent;
        this.recordType = copiedRecord.recordType;
        this.partitionId = copiedRecord.partitionId;
        this.rejectionType = copiedRecord.rejectionType;
        this.rejectionReason = copiedRecord.rejectionReason;
        this.valueType = copiedRecord.valueType;
        this.brokerVersion = copiedRecord.brokerVersion;
        this.authorization = copiedRecord.authorization;
        this.recordVersion = copiedRecord.recordVersion;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public long getSourceRecordPosition() {
        return this.sourcePosition;
    }

    @Override
    public long getKey() {
        return this.key;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Intent getIntent() {
        return this.intent;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public RecordType getRecordType() {
        return this.recordType;
    }

    @Override
    public RejectionType getRejectionType() {
        return this.rejectionType;
    }

    @Override
    public String getRejectionReason() {
        return this.rejectionReason;
    }

    @Override
    public String getBrokerVersion() {
        return this.brokerVersion;
    }

    @Override
    public Map<String, Object> getAuthorizations() {
        return this.authorization.toDecodedMap();
    }

    @Override
    public int getRecordVersion() {
        return this.recordVersion;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    @Override
    public T getValue() {
        return this.recordValue;
    }

    @Override
    public Record<T> copyOf() {
        return new CopiedRecord<T>(this);
    }

    @Override
    public String toJson() {
        return MsgPackConverter.convertJsonSerializableObjectToJson(this);
    }

    public String toString() {
        return StringUtil.limitString(this.toJson(), 1024);
    }
}

