/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.compensation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.CompensationSubscriptionRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public class CompensationSubscriptionRecord
extends UnifiedRecordValue
implements CompensationSubscriptionRecordValue {
    private static final String EMPTY_STRING = "";
    private final StringProperty tenantIdProperty = new StringProperty("tenantId", "<default>");
    private final LongProperty processInstanceKeyProperty = new LongProperty("processInstanceKey", -1L);
    private final LongProperty processDefinitionKeyProperty = new LongProperty("processDefinitionKey", -1L);
    private final StringProperty compensableActivityIdProperty = new StringProperty("compensableActivityId", "");
    private final StringProperty throwEventIdProperty = new StringProperty("throwEventId", "");
    private final LongProperty throwEventInstanceKeyProperty = new LongProperty("throwEventInstanceKey", -1L);
    private final StringProperty compensationHandlerIdProperty = new StringProperty("compensationHandlerId", "");
    private final LongProperty compensationHandlerInstanceKeyProperty = new LongProperty("compensationHandlerInstanceKey", -1L);
    private final LongProperty compensableActivityScopeKeyProperty = new LongProperty("compensableActivityScopeKey", -1L);
    private final LongProperty compensableActivityInstanceKeyProperty = new LongProperty("compensableActivityInstanceKey", -1L);
    private final DocumentProperty variablesProperty = new DocumentProperty("variables");

    public CompensationSubscriptionRecord() {
        super(11);
        this.declareProperty(this.tenantIdProperty).declareProperty(this.processInstanceKeyProperty).declareProperty(this.processDefinitionKeyProperty).declareProperty(this.compensableActivityIdProperty).declareProperty(this.throwEventIdProperty).declareProperty(this.throwEventInstanceKeyProperty).declareProperty(this.compensationHandlerIdProperty).declareProperty(this.compensationHandlerInstanceKeyProperty).declareProperty(this.compensableActivityScopeKeyProperty).declareProperty(this.compensableActivityInstanceKeyProperty).declareProperty(this.variablesProperty);
    }

    public void wrap(CompensationSubscriptionRecord record) {
        this.tenantIdProperty.setValue(record.getTenantId());
        this.processInstanceKeyProperty.setValue(record.getProcessInstanceKey());
        this.processDefinitionKeyProperty.setValue(record.getProcessDefinitionKey());
        this.compensableActivityIdProperty.setValue(record.getCompensableActivityId());
        this.throwEventIdProperty.setValue(record.getThrowEventId());
        this.throwEventInstanceKeyProperty.setValue(record.getThrowEventInstanceKey());
        this.compensationHandlerIdProperty.setValue(record.getCompensationHandlerId());
        this.compensationHandlerInstanceKeyProperty.setValue(record.getCompensationHandlerInstanceKey());
        this.compensableActivityScopeKeyProperty.setValue(record.getCompensableActivityScopeKey());
        this.compensableActivityInstanceKeyProperty.setValue(record.getCompensableActivityInstanceKey());
        this.variablesProperty.setValue(record.getVariablesBuffer());
    }

    @Override
    public String getTenantId() {
        return BufferUtil.bufferAsString(this.tenantIdProperty.getValue());
    }

    public CompensationSubscriptionRecord setTenantId(String tenantId) {
        this.tenantIdProperty.setValue(tenantId);
        return this;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProperty.getValue();
    }

    public CompensationSubscriptionRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProperty.setValue(processInstanceKey);
        return this;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKeyProperty.getValue();
    }

    public CompensationSubscriptionRecord setProcessDefinitionKey(long processDefinitionKey) {
        this.processDefinitionKeyProperty.setValue(processDefinitionKey);
        return this;
    }

    @Override
    public String getCompensableActivityId() {
        return BufferUtil.bufferAsString(this.compensableActivityIdProperty.getValue());
    }

    @Override
    public String getThrowEventId() {
        return BufferUtil.bufferAsString(this.throwEventIdProperty.getValue());
    }

    @Override
    public long getThrowEventInstanceKey() {
        return this.throwEventInstanceKeyProperty.getValue();
    }

    @Override
    public String getCompensationHandlerId() {
        return BufferUtil.bufferAsString(this.compensationHandlerIdProperty.getValue());
    }

    @Override
    public long getCompensationHandlerInstanceKey() {
        return this.compensationHandlerInstanceKeyProperty.getValue();
    }

    @Override
    public long getCompensableActivityScopeKey() {
        return this.compensableActivityScopeKeyProperty.getValue();
    }

    @Override
    public long getCompensableActivityInstanceKey() {
        return this.compensableActivityInstanceKeyProperty.getValue();
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProperty.getValue());
    }

    public CompensationSubscriptionRecord setVariables(DirectBuffer variables) {
        this.variablesProperty.setValue(variables);
        return this;
    }

    public CompensationSubscriptionRecord setCompensableActivityInstanceKey(long compensableActivityInstanceKey) {
        this.compensableActivityInstanceKeyProperty.setValue(compensableActivityInstanceKey);
        return this;
    }

    public CompensationSubscriptionRecord setCompensableActivityScopeKey(long scopeInstanceKey) {
        this.compensableActivityScopeKeyProperty.setValue(scopeInstanceKey);
        return this;
    }

    public CompensationSubscriptionRecord setCompensationHandlerInstanceKey(long compensationHandlerInstanceKey) {
        this.compensationHandlerInstanceKeyProperty.setValue(compensationHandlerInstanceKey);
        return this;
    }

    public CompensationSubscriptionRecord setCompensationHandlerId(String compensationHandlerId) {
        this.compensationHandlerIdProperty.setValue(compensationHandlerId);
        return this;
    }

    public CompensationSubscriptionRecord setThrowEventInstanceKey(long throwEventInstanceKey) {
        this.throwEventInstanceKeyProperty.setValue(throwEventInstanceKey);
        return this;
    }

    public CompensationSubscriptionRecord setThrowEventId(String throwEventId) {
        this.throwEventIdProperty.setValue(throwEventId);
        return this;
    }

    public CompensationSubscriptionRecord setCompensableActivityId(String compensableActivityId) {
        this.compensableActivityIdProperty.setValue(compensableActivityId);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProperty.getValue();
    }
}

