/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.deployment;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BinaryProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.ProcessMetadata;
import io.camunda.zeebe.protocol.record.value.deployment.Process;
import io.camunda.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class ProcessRecord
extends UnifiedRecordValue
implements Process {
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId");
    private final IntegerProperty versionProp = new IntegerProperty("version");
    private final LongProperty keyProp = new LongProperty("processDefinitionKey");
    private final StringProperty resourceNameProp = new StringProperty("resourceName");
    private final BinaryProperty checksumProp = new BinaryProperty("checksum", new UnsafeBuffer());
    private final BinaryProperty resourceProp = new BinaryProperty("resource", new UnsafeBuffer());
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public ProcessRecord() {
        super(7);
        this.declareProperty(this.bpmnProcessIdProp).declareProperty(this.versionProp).declareProperty(this.keyProp).declareProperty(this.resourceNameProp).declareProperty(this.checksumProp).declareProperty(this.resourceProp).declareProperty(this.tenantIdProp);
    }

    public ProcessRecord wrap(ProcessMetadata metadata, byte[] resource) {
        this.bpmnProcessIdProp.setValue(metadata.getBpmnProcessIdBuffer());
        this.versionProp.setValue(metadata.getVersion());
        this.checksumProp.setValue(metadata.getChecksumBuffer());
        this.keyProp.setValue(metadata.getKey());
        this.resourceNameProp.setValue(metadata.getResourceNameBuffer());
        this.resourceProp.setValue(BufferUtil.wrapArray(resource));
        this.tenantIdProp.setValue(metadata.getTenantId());
        return this;
    }

    @Override
    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString(this.bpmnProcessIdProp.getValue());
    }

    @Override
    public int getVersion() {
        return this.versionProp.getValue();
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.getKey();
    }

    @Override
    public String getResourceName() {
        return BufferUtil.bufferAsString(this.resourceNameProp.getValue());
    }

    @Override
    public byte[] getChecksum() {
        return BufferUtil.bufferAsArray(this.checksumProp.getValue());
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    public ProcessRecord setChecksum(DirectBuffer checksumBuffer) {
        this.checksumProp.setValue(checksumBuffer);
        return this;
    }

    public ProcessRecord setResourceName(String resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ProcessRecord setResourceName(DirectBuffer resourceName) {
        this.resourceNameProp.setValue(resourceName);
        return this;
    }

    public ProcessRecord setVersion(int version) {
        this.versionProp.setValue(version);
        return this;
    }

    public ProcessRecord setBpmnProcessId(String bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    public ProcessRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getChecksumBuffer() {
        return this.checksumProp.getValue();
    }

    @Override
    public byte[] getResource() {
        return BufferUtil.bufferAsArray(this.resourceProp.getValue());
    }

    public ProcessRecord setResource(DirectBuffer resource) {
        return this.setResource(resource, 0, resource.capacity());
    }

    @JsonIgnore
    public long getKey() {
        return this.keyProp.getValue();
    }

    public ProcessRecord setKey(long key) {
        this.keyProp.setValue(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return super.getLength();
    }

    @Override
    @JsonIgnore
    public int getEncodedLength() {
        return super.getEncodedLength();
    }

    @JsonIgnore
    public DirectBuffer getResourceNameBuffer() {
        return this.resourceNameProp.getValue();
    }

    public ProcessRecord setBpmnProcessId(DirectBuffer bpmnProcessId, int offset, int length) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId, offset, length);
        return this;
    }

    public ProcessRecord setResource(DirectBuffer resource, int offset, int length) {
        this.resourceProp.setValue(resource, offset, length);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getResourceBuffer() {
        return this.resourceProp.getValue();
    }

    @Override
    public String getTenantId() {
        return BufferUtil.bufferAsString(this.tenantIdProp.getValue());
    }

    public ProcessRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

