/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.distribution;

import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.ObjectProperty;
import io.camunda.zeebe.msgpack.spec.MsgPackReader;
import io.camunda.zeebe.msgpack.spec.MsgPackWriter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.resource.ResourceDeletionRecord;
import io.camunda.zeebe.protocol.impl.record.value.signal.SignalRecord;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.value.CommandDistributionRecordValue;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import org.agrona.concurrent.UnsafeBuffer;

public final class CommandDistributionRecord
extends UnifiedRecordValue
implements CommandDistributionRecordValue {
    private static final Map<ValueType, Supplier<UnifiedRecordValue>> RECORDS_BY_TYPE = new EnumMap<ValueType, Supplier<UnifiedRecordValue>>(ValueType.class);
    private final IntegerProperty partitionIdProperty = new IntegerProperty("partitionId");
    private final EnumProperty<ValueType> valueTypeProperty = new EnumProperty<ValueType>("valueType", ValueType.class, ValueType.NULL_VAL);
    private final IntegerProperty intentProperty = new IntegerProperty("intent", 255);
    private final ObjectProperty<UnifiedRecordValue> commandValueProperty = new ObjectProperty<UnifiedRecordValue>("commandValue", new UnifiedRecordValue(10));
    private final MsgPackWriter commandValueWriter = new MsgPackWriter();
    private final MsgPackReader commandValueReader = new MsgPackReader();

    public CommandDistributionRecord() {
        super(4);
        this.declareProperty(this.partitionIdProperty).declareProperty(this.valueTypeProperty).declareProperty(this.intentProperty).declareProperty(this.commandValueProperty);
    }

    public CommandDistributionRecord wrap(CommandDistributionRecord other) {
        this.setPartitionId(other.getPartitionId()).setValueType(other.getValueType()).setIntent(other.getIntent()).setCommandValue(other.getCommandValue());
        return this;
    }

    @Override
    public int getPartitionId() {
        return this.partitionIdProperty.getValue();
    }

    @Override
    public ValueType getValueType() {
        return this.valueTypeProperty.getValue();
    }

    @Override
    public Intent getIntent() {
        int intentValue = this.intentProperty.getValue();
        if (intentValue < 0 || intentValue > Short.MAX_VALUE) {
            throw new IllegalStateException(String.format("Expected to read the intent, but it's persisted value '%d' is not a short integer", intentValue));
        }
        return Intent.fromProtocolValue(this.getValueType(), (short)intentValue);
    }

    @Override
    public UnifiedRecordValue getCommandValue() {
        ValueType valueType = this.getValueType();
        if (valueType == ValueType.NULL_VAL) {
            return null;
        }
        UnifiedRecordValue storedCommandValue = this.commandValueProperty.getValue();
        if (storedCommandValue.isEmpty()) {
            return storedCommandValue;
        }
        Supplier<UnifiedRecordValue> concrecteCommandValueSupplier = RECORDS_BY_TYPE.get((Object)valueType);
        if (concrecteCommandValueSupplier == null) {
            throw new IllegalStateException("Expected to read the record value, but it's type `" + valueType.name() + "` is unknown. Please add it to CommandDistributionRecord.RECORDS_BY_TYPE");
        }
        UnifiedRecordValue concreteCommandValue = concrecteCommandValueSupplier.get();
        UnsafeBuffer commandValueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = storedCommandValue.getEncodedLength();
        commandValueBuffer.wrap(new byte[encodedLength]);
        storedCommandValue.write(this.commandValueWriter.wrap(commandValueBuffer, 0));
        concreteCommandValue.wrap(commandValueBuffer);
        return concreteCommandValue;
    }

    public CommandDistributionRecord setCommandValue(UnifiedRecordValue commandValue) {
        if (commandValue == null) {
            this.commandValueProperty.reset();
            return this;
        }
        UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = commandValue.getLength();
        valueBuffer.wrap(new byte[encodedLength]);
        commandValue.write(valueBuffer, 0);
        this.commandValueProperty.getValue().read(this.commandValueReader.wrap(valueBuffer, 0, encodedLength));
        return this;
    }

    public CommandDistributionRecord setIntent(Intent intent) {
        this.intentProperty.setValue(intent.value());
        return this;
    }

    public CommandDistributionRecord setValueType(ValueType valueType) {
        this.valueTypeProperty.setValue(valueType);
        return this;
    }

    public CommandDistributionRecord setPartitionId(int partitionId) {
        this.partitionIdProperty.setValue(partitionId);
        return this;
    }

    static {
        RECORDS_BY_TYPE.put(ValueType.DEPLOYMENT, DeploymentRecord::new);
        RECORDS_BY_TYPE.put(ValueType.RESOURCE_DELETION, ResourceDeletionRecord::new);
        RECORDS_BY_TYPE.put(ValueType.SIGNAL, SignalRecord::new);
    }
}

