/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.message;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.BooleanProperty;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.IntegerProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessMessageSubscriptionRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class ProcessMessageSubscriptionRecord
extends UnifiedRecordValue
implements ProcessMessageSubscriptionRecordValue {
    private final IntegerProperty subscriptionPartitionIdProp = new IntegerProperty("subscriptionPartitionId");
    private final LongProperty processInstanceKeyProp = new LongProperty("processInstanceKey");
    private final LongProperty elementInstanceKeyProp = new LongProperty("elementInstanceKey");
    private final StringProperty bpmnProcessIdProp = new StringProperty("bpmnProcessId", "");
    private final LongProperty messageKeyProp = new LongProperty("messageKey", -1L);
    private final StringProperty messageNameProp = new StringProperty("messageName", "");
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final BooleanProperty interruptingProp = new BooleanProperty("interrupting", true);
    private final StringProperty correlationKeyProp = new StringProperty("correlationKey", "");
    private final StringProperty elementIdProp = new StringProperty("elementId", "");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public ProcessMessageSubscriptionRecord() {
        super(11);
        this.declareProperty(this.subscriptionPartitionIdProp).declareProperty(this.processInstanceKeyProp).declareProperty(this.elementInstanceKeyProp).declareProperty(this.messageKeyProp).declareProperty(this.messageNameProp).declareProperty(this.variablesProp).declareProperty(this.interruptingProp).declareProperty(this.bpmnProcessIdProp).declareProperty(this.correlationKeyProp).declareProperty(this.elementIdProp).declareProperty(this.tenantIdProp);
    }

    public void wrap(ProcessMessageSubscriptionRecord record) {
        this.setSubscriptionPartitionId(record.getSubscriptionPartitionId());
        this.setProcessInstanceKey(record.getProcessInstanceKey());
        this.setElementInstanceKey(record.getElementInstanceKey());
        this.setMessageKey(record.getMessageKey());
        this.setMessageName(record.getMessageNameBuffer());
        this.setVariables(record.getVariablesBuffer());
        this.setInterrupting(record.isInterrupting());
        this.setBpmnProcessId(record.getBpmnProcessIdBuffer());
        this.setCorrelationKey(record.getCorrelationKeyBuffer());
        this.setElementId(record.getElementIdBuffer());
        this.setTenantId(record.getTenantId());
    }

    @JsonIgnore
    public DirectBuffer getBpmnProcessIdBuffer() {
        return this.bpmnProcessIdProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getMessageNameBuffer() {
        return this.messageNameProp.getValue();
    }

    @JsonIgnore
    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionIdProp.getValue();
    }

    public ProcessMessageSubscriptionRecord setSubscriptionPartitionId(int partitionId) {
        this.subscriptionPartitionIdProp.setValue(partitionId);
        return this;
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public ProcessMessageSubscriptionRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProp.getValue();
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKeyProp.getValue();
    }

    public ProcessMessageSubscriptionRecord setElementInstanceKey(long key) {
        this.elementInstanceKeyProp.setValue(key);
        return this;
    }

    @Override
    public String getBpmnProcessId() {
        return BufferUtil.bufferAsString(this.bpmnProcessIdProp.getValue());
    }

    public ProcessMessageSubscriptionRecord setBpmnProcessId(DirectBuffer bpmnProcessId) {
        this.bpmnProcessIdProp.setValue(bpmnProcessId);
        return this;
    }

    @Override
    public long getMessageKey() {
        return this.messageKeyProp.getValue();
    }

    @Override
    public String getMessageName() {
        return BufferUtil.bufferAsString(this.messageNameProp.getValue());
    }

    @Override
    public String getCorrelationKey() {
        return BufferUtil.bufferAsString(this.correlationKeyProp.getValue());
    }

    public ProcessMessageSubscriptionRecord setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKeyProp.setValue(correlationKey);
        return this;
    }

    @Override
    public String getElementId() {
        return BufferUtil.bufferAsString(this.getElementIdBuffer());
    }

    @Override
    public boolean isInterrupting() {
        return this.interruptingProp.getValue();
    }

    public ProcessMessageSubscriptionRecord setInterrupting(boolean interrupting) {
        this.interruptingProp.setValue(interrupting);
        return this;
    }

    public ProcessMessageSubscriptionRecord setElementId(DirectBuffer elementId) {
        this.elementIdProp.setValue(elementId);
        return this;
    }

    public ProcessMessageSubscriptionRecord setMessageName(DirectBuffer messageName) {
        this.messageNameProp.setValue(messageName);
        return this;
    }

    public ProcessMessageSubscriptionRecord setMessageKey(long messageKey) {
        this.messageKeyProp.setValue(messageKey);
        return this;
    }

    public ProcessMessageSubscriptionRecord setProcessInstanceKey(long key) {
        this.processInstanceKeyProp.setValue(key);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getCorrelationKeyBuffer() {
        return this.correlationKeyProp.getValue();
    }

    @JsonIgnore
    public DirectBuffer getElementIdBuffer() {
        return this.elementIdProp.getValue();
    }

    @Override
    public String getTenantId() {
        return BufferUtil.bufferAsString(this.tenantIdProp.getValue());
    }

    public ProcessMessageSubscriptionRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

