/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.processinstance;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationActivateInstruction;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceModificationTerminateInstruction;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceModificationRecordValue;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public final class ProcessInstanceModificationRecord
extends UnifiedRecordValue
implements ProcessInstanceModificationRecordValue {
    private final LongProperty processInstanceKeyProperty = new LongProperty("processInstanceKey");
    private final ArrayProperty<ProcessInstanceModificationTerminateInstruction> terminateInstructionsProperty = new ArrayProperty<ProcessInstanceModificationTerminateInstruction>("terminateInstructions", ProcessInstanceModificationTerminateInstruction::new);
    private final ArrayProperty<ProcessInstanceModificationActivateInstruction> activateInstructionsProperty = new ArrayProperty<ProcessInstanceModificationActivateInstruction>("activateInstructions", ProcessInstanceModificationActivateInstruction::new);
    @Deprecated(since="8.1.3")
    private final ArrayProperty<LongValue> activatedElementInstanceKeys = new ArrayProperty<LongValue>("activatedElementInstanceKeys", LongValue::new);

    public ProcessInstanceModificationRecord() {
        super(4);
        this.declareProperty(this.processInstanceKeyProperty).declareProperty(this.terminateInstructionsProperty).declareProperty(this.activateInstructionsProperty).declareProperty(this.activatedElementInstanceKeys);
    }

    @Override
    public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue> getTerminateInstructions() {
        return this.terminateInstructionsProperty.stream().map(element -> {
            ProcessInstanceModificationTerminateInstruction elementCopy = new ProcessInstanceModificationTerminateInstruction();
            elementCopy.copy((ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue)element);
            return elementCopy;
        }).toList();
    }

    @Override
    public List<ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue> getActivateInstructions() {
        return this.activateInstructionsProperty.stream().map(element -> {
            ProcessInstanceModificationActivateInstruction elementCopy = new ProcessInstanceModificationActivateInstruction();
            elementCopy.copy((ProcessInstanceModificationActivateInstruction)element);
            return elementCopy;
        }).toList();
    }

    @Override
    public Set<Long> getAncestorScopeKeys() {
        Set<Long> activatedElementInstanceKeys = this.activatedElementInstanceKeys.stream().map(LongValue::getValue).collect(Collectors.toSet());
        activatedElementInstanceKeys.addAll(this.getActivateInstructions().stream().map(ProcessInstanceModificationRecordValue.ProcessInstanceModificationActivateInstructionValue::getAncestorScopeKeys).flatMap(Collection::stream).collect(Collectors.toSet()));
        return activatedElementInstanceKeys;
    }

    @JsonIgnore
    public boolean hasTerminateInstructions() {
        return !this.terminateInstructionsProperty.isEmpty();
    }

    public ProcessInstanceModificationRecord addTerminateInstruction(ProcessInstanceModificationRecordValue.ProcessInstanceModificationTerminateInstructionValue terminateInstruction) {
        ((ProcessInstanceModificationTerminateInstruction)this.terminateInstructionsProperty.add()).copy(terminateInstruction);
        return this;
    }

    @JsonIgnore
    public boolean hasActivateInstructions() {
        return !this.activateInstructionsProperty.isEmpty();
    }

    public ProcessInstanceModificationRecord addActivateInstruction(ProcessInstanceModificationActivateInstruction activateInstruction) {
        ((ProcessInstanceModificationActivateInstruction)this.activateInstructionsProperty.add()).copy(activateInstruction);
        return this;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKeyProperty.getValue();
    }

    public ProcessInstanceModificationRecord setProcessInstanceKey(long processInstanceKey) {
        this.processInstanceKeyProperty.setValue(processInstanceKey);
        return this;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public String getTenantId() {
        return "<default>";
    }
}

