/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.signal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.SignalRecordValue;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;

public final class SignalRecord
extends UnifiedRecordValue
implements SignalRecordValue {
    private final StringProperty signalNameProp = new StringProperty("signalName");
    private final DocumentProperty variablesProp = new DocumentProperty("variables");
    private final StringProperty tenantIdProp = new StringProperty("tenantId", "<default>");

    public SignalRecord() {
        super(3);
        this.declareProperty(this.signalNameProp).declareProperty(this.variablesProp).declareProperty(this.tenantIdProp);
    }

    public void wrap(SignalRecord record) {
        this.setSignalName(record.getSignalNameBuffer()).setVariables(record.getVariablesBuffer()).setTenantId(record.getTenantId());
    }

    @Override
    public String getSignalName() {
        return BufferUtil.bufferAsString(this.signalNameProp.getValue());
    }

    public SignalRecord setSignalName(String signalName) {
        this.signalNameProp.setValue(signalName);
        return this;
    }

    public SignalRecord setSignalName(DirectBuffer signalName) {
        this.signalNameProp.setValue(signalName);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getSignalNameBuffer() {
        return this.signalNameProp.getValue();
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProp.getValue());
    }

    public SignalRecord setVariables(DirectBuffer variables) {
        this.variablesProp.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProp.getValue();
    }

    @Override
    public String getTenantId() {
        return BufferUtil.bufferAsString(this.tenantIdProp.getValue());
    }

    public SignalRecord setTenantId(String tenantId) {
        this.tenantIdProp.setValue(tenantId);
        return this;
    }
}

