/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.record.value.variable;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.msgpack.property.DocumentProperty;
import io.camunda.zeebe.msgpack.property.EnumProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentRecordValue;
import io.camunda.zeebe.protocol.record.value.VariableDocumentUpdateSemantic;
import java.util.Map;
import java.util.Objects;
import org.agrona.DirectBuffer;

public final class VariableDocumentRecord
extends UnifiedRecordValue
implements VariableDocumentRecordValue {
    private final LongProperty scopeKeyProperty = new LongProperty("scopeKey");
    private final EnumProperty<VariableDocumentUpdateSemantic> updateSemanticsProperty = new EnumProperty<VariableDocumentUpdateSemantic>("updateSemantics", VariableDocumentUpdateSemantic.class, VariableDocumentUpdateSemantic.PROPAGATE);
    private final DocumentProperty variablesProperty = new DocumentProperty("variables");

    public VariableDocumentRecord() {
        super(3);
        this.declareProperty(this.scopeKeyProperty).declareProperty(this.updateSemanticsProperty).declareProperty(this.variablesProperty);
    }

    public VariableDocumentRecord wrap(VariableDocumentRecord other) {
        this.setScopeKey(other.getScopeKey()).setVariables(other.getVariablesBuffer()).setUpdateSemantics(other.getUpdateSemantics());
        return this;
    }

    @Override
    public long getScopeKey() {
        return this.scopeKeyProperty.getValue();
    }

    public VariableDocumentRecord setScopeKey(long scopeKey) {
        this.scopeKeyProperty.setValue(scopeKey);
        return this;
    }

    @Override
    public VariableDocumentUpdateSemantic getUpdateSemantics() {
        return this.updateSemanticsProperty.getValue();
    }

    public VariableDocumentRecord setUpdateSemantics(VariableDocumentUpdateSemantic updateSemantics) {
        this.updateSemanticsProperty.setValue(updateSemantics);
        return this;
    }

    @Override
    public Map<String, Object> getVariables() {
        return MsgPackConverter.convertToMap(this.variablesProperty.getValue());
    }

    public VariableDocumentRecord setVariables(DirectBuffer variables) {
        this.variablesProperty.setValue(variables);
        return this;
    }

    @JsonIgnore
    public DirectBuffer getVariablesBuffer() {
        return this.variablesProperty.getValue();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.scopeKeyProperty, this.updateSemanticsProperty, this.variablesProperty);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof VariableDocumentRecord)) {
            return false;
        }
        VariableDocumentRecord that = (VariableDocumentRecord)o;
        return Objects.equals(this.scopeKeyProperty, that.scopeKeyProperty) && Objects.equals(this.updateSemanticsProperty, that.updateSemanticsProperty) && Objects.equals(this.variablesProperty, that.variablesProperty);
    }

    @Override
    public String getTenantId() {
        return "<default>";
    }
}

