/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.impl.stream.job;

import io.camunda.zeebe.msgpack.UnpackedObject;
import io.camunda.zeebe.msgpack.property.ArrayProperty;
import io.camunda.zeebe.msgpack.property.LongProperty;
import io.camunda.zeebe.msgpack.property.StringProperty;
import io.camunda.zeebe.msgpack.value.StringValue;
import io.camunda.zeebe.protocol.impl.stream.job.JobActivationProperties;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import org.agrona.DirectBuffer;

public class JobActivationPropertiesImpl
extends UnpackedObject
implements JobActivationProperties {
    private final StringProperty workerProp = new StringProperty("worker", "");
    private final LongProperty timeoutProp = new LongProperty("timeout", -1L);
    private final ArrayProperty<StringValue> fetchVariablesProp = new ArrayProperty<StringValue>("variables", StringValue::new);
    private final ArrayProperty<StringValue> tenantIdsProp = new ArrayProperty<StringValue>("tenantIds", () -> new StringValue("<default>"));

    public JobActivationPropertiesImpl() {
        super(4);
        this.declareProperty(this.workerProp).declareProperty(this.timeoutProp).declareProperty(this.fetchVariablesProp).declareProperty(this.tenantIdsProp);
    }

    public JobActivationPropertiesImpl setWorker(DirectBuffer worker, int offset, int length) {
        this.workerProp.setValue(worker, offset, length);
        return this;
    }

    public JobActivationPropertiesImpl setTimeout(long val) {
        this.timeoutProp.setValue(val);
        return this;
    }

    public JobActivationPropertiesImpl setFetchVariables(Collection<StringValue> variables) {
        this.fetchVariablesProp.reset();
        variables.forEach(variable -> ((StringValue)this.fetchVariablesProp.add()).wrap((StringValue)variable));
        return this;
    }

    public JobActivationPropertiesImpl setTenantIds(Collection<String> tenantIds) {
        this.tenantIdsProp.reset();
        tenantIds.forEach(tenantId -> ((StringValue)this.tenantIdsProp.add()).wrap(BufferUtil.wrapString(tenantId)));
        return this;
    }

    @Override
    public DirectBuffer worker() {
        return this.workerProp.getValue();
    }

    @Override
    public Collection<DirectBuffer> fetchVariables() {
        return this.fetchVariablesProp.stream().map(StringValue::getValue).toList();
    }

    @Override
    public long timeout() {
        return this.timeoutProp.getValue();
    }

    @Override
    public Collection<String> tenantIds() {
        return this.tenantIdsProp.stream().map(StringValue::toString).toList();
    }
}

