/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.management;

import io.camunda.zeebe.protocol.management.BackupRequestType;
import io.camunda.zeebe.protocol.management.MessageHeaderDecoder;
import io.camunda.zeebe.protocol.management.MetaAttribute;
import java.nio.ByteOrder;
import org.agrona.DirectBuffer;
import org.agrona.sbe.MessageDecoderFlyweight;

public final class BackupRequestDecoder
implements MessageDecoderFlyweight {
    public static final int BLOCK_LENGTH = 11;
    public static final int TEMPLATE_ID = 3;
    public static final int SCHEMA_ID = 1;
    public static final int SCHEMA_VERSION = 0;
    public static final String SEMANTIC_VERSION = "8.6.0-alpha1";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final BackupRequestDecoder parentMessage = this;
    private DirectBuffer buffer;
    private int offset;
    private int limit;
    int actingBlockLength;
    int actingVersion;

    @Override
    public int sbeBlockLength() {
        return 11;
    }

    @Override
    public int sbeTemplateId() {
        return 3;
    }

    @Override
    public int sbeSchemaId() {
        return 1;
    }

    @Override
    public int sbeSchemaVersion() {
        return 0;
    }

    @Override
    public String sbeSemanticType() {
        return "";
    }

    @Override
    public DirectBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int offset() {
        return this.offset;
    }

    @Override
    public BackupRequestDecoder wrap(DirectBuffer buffer, int offset, int actingBlockLength, int actingVersion) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.actingBlockLength = actingBlockLength;
        this.actingVersion = actingVersion;
        this.limit(offset + actingBlockLength);
        return this;
    }

    public BackupRequestDecoder wrapAndApplyHeader(DirectBuffer buffer, int offset, MessageHeaderDecoder headerDecoder) {
        headerDecoder.wrap(buffer, offset);
        int templateId = headerDecoder.templateId();
        if (3 != templateId) {
            throw new IllegalStateException("Invalid TEMPLATE_ID: " + templateId);
        }
        return this.wrap(buffer, offset + 8, headerDecoder.blockLength(), headerDecoder.version());
    }

    public BackupRequestDecoder sbeRewind() {
        return this.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
    }

    @Override
    public int sbeDecodedLength() {
        int currentLimit = this.limit();
        this.sbeSkip();
        int decodedLength = this.encodedLength();
        this.limit(currentLimit);
        return decodedLength;
    }

    public int actingVersion() {
        return this.actingVersion;
    }

    @Override
    public int encodedLength() {
        return this.limit - this.offset;
    }

    @Override
    public int limit() {
        return this.limit;
    }

    @Override
    public void limit(int limit) {
        this.limit = limit;
    }

    public static int partitionIdId() {
        return 1;
    }

    public static int partitionIdSinceVersion() {
        return 0;
    }

    public static int partitionIdEncodingOffset() {
        return 0;
    }

    public static int partitionIdEncodingLength() {
        return 2;
    }

    public static String partitionIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static int partitionIdNullValue() {
        return 65535;
    }

    public static int partitionIdMinValue() {
        return 0;
    }

    public static int partitionIdMaxValue() {
        return 65534;
    }

    public int partitionId() {
        return this.buffer.getShort(this.offset + 0, BYTE_ORDER) & 0xFFFF;
    }

    public static int typeId() {
        return 2;
    }

    public static int typeSinceVersion() {
        return 0;
    }

    public static int typeEncodingOffset() {
        return 2;
    }

    public static int typeEncodingLength() {
        return 1;
    }

    public static String typeMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public short typeRaw() {
        return (short)(this.buffer.getByte(this.offset + 2) & 0xFF);
    }

    public BackupRequestType type() {
        return BackupRequestType.get((short)(this.buffer.getByte(this.offset + 2) & 0xFF));
    }

    public static int backupIdId() {
        return 3;
    }

    public static int backupIdSinceVersion() {
        return 0;
    }

    public static int backupIdEncodingOffset() {
        return 3;
    }

    public static int backupIdEncodingLength() {
        return 8;
    }

    public static String backupIdMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long backupIdNullValue() {
        return Long.MIN_VALUE;
    }

    public static long backupIdMinValue() {
        return -9223372036854775807L;
    }

    public static long backupIdMaxValue() {
        return Long.MAX_VALUE;
    }

    public long backupId() {
        return this.buffer.getLong(this.offset + 3, BYTE_ORDER);
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        BackupRequestDecoder decoder = new BackupRequestDecoder();
        decoder.wrap(this.buffer, this.offset, this.actingBlockLength, this.actingVersion);
        return decoder.appendTo(new StringBuilder()).toString();
    }

    @Override
    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        int originalLimit = this.limit();
        this.limit(this.offset + this.actingBlockLength);
        builder.append("[BackupRequest](sbeTemplateId=");
        builder.append(3);
        builder.append("|sbeSchemaId=");
        builder.append(1);
        builder.append("|sbeSchemaVersion=");
        if (this.parentMessage.actingVersion != 0) {
            builder.append(this.parentMessage.actingVersion);
            builder.append('/');
        }
        builder.append(0);
        builder.append("|sbeBlockLength=");
        if (this.actingBlockLength != 11) {
            builder.append(this.actingBlockLength);
            builder.append('/');
        }
        builder.append(11);
        builder.append("):");
        builder.append("partitionId=");
        builder.append(this.partitionId());
        builder.append('|');
        builder.append("type=");
        builder.append((Object)this.type());
        builder.append('|');
        builder.append("backupId=");
        builder.append(this.backupId());
        this.limit(originalLimit);
        return builder;
    }

    public BackupRequestDecoder sbeSkip() {
        this.sbeRewind();
        return this;
    }
}

