/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.ErrorType;
import io.camunda.zeebe.protocol.record.value.IncidentRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="IncidentRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableIncidentRecordValue
implements IncidentRecordValue {
    private final String tenantId;
    private final ErrorType errorType;
    private final String errorMessage;
    private final String bpmnProcessId;
    private final long processDefinitionKey;
    private final long processInstanceKey;
    private final String elementId;
    private final long elementInstanceKey;
    private final long jobKey;
    private final long variableScopeKey;
    private transient int hashCode;

    private ImmutableIncidentRecordValue(String tenantId, ErrorType errorType, String errorMessage, String bpmnProcessId, long processDefinitionKey, long processInstanceKey, String elementId, long elementInstanceKey, long jobKey, long variableScopeKey) {
        this.tenantId = tenantId;
        this.errorType = errorType;
        this.errorMessage = errorMessage;
        this.bpmnProcessId = bpmnProcessId;
        this.processDefinitionKey = processDefinitionKey;
        this.processInstanceKey = processInstanceKey;
        this.elementId = elementId;
        this.elementInstanceKey = elementInstanceKey;
        this.jobKey = jobKey;
        this.variableScopeKey = variableScopeKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public long getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public String getElementId() {
        return this.elementId;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public long getJobKey() {
        return this.jobKey;
    }

    @Override
    public long getVariableScopeKey() {
        return this.variableScopeKey;
    }

    public final ImmutableIncidentRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(value, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withErrorType(ErrorType value) {
        if (this.errorType == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, value, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withErrorMessage(String value) {
        if (Objects.equals(this.errorMessage, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, value, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, value, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withProcessDefinitionKey(long value) {
        if (this.processDefinitionKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, value, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, value, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withElementId(String value) {
        if (Objects.equals(this.elementId, value)) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, value, this.elementInstanceKey, this.jobKey, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withElementInstanceKey(long value) {
        if (this.elementInstanceKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, value, this.jobKey, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withJobKey(long value) {
        if (this.jobKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, value, this.variableScopeKey);
    }

    public final ImmutableIncidentRecordValue withVariableScopeKey(long value) {
        if (this.variableScopeKey == value) {
            return this;
        }
        return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIncidentRecordValue && this.equalTo(0, (ImmutableIncidentRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableIncidentRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.tenantId, another.tenantId) && Objects.equals((Object)this.errorType, (Object)another.errorType) && Objects.equals(this.errorMessage, another.errorMessage) && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && this.processDefinitionKey == another.processDefinitionKey && this.processInstanceKey == another.processInstanceKey && Objects.equals(this.elementId, another.elementId) && this.elementInstanceKey == another.elementInstanceKey && this.jobKey == another.jobKey && this.variableScopeKey == another.variableScopeKey;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.tenantId);
        h2 += (h2 << 5) + Objects.hashCode((Object)this.errorType);
        h2 += (h2 << 5) + Objects.hashCode(this.errorMessage);
        h2 += (h2 << 5) + Objects.hashCode(this.bpmnProcessId);
        h2 += (h2 << 5) + Long.hashCode(this.processDefinitionKey);
        h2 += (h2 << 5) + Long.hashCode(this.processInstanceKey);
        h2 += (h2 << 5) + Objects.hashCode(this.elementId);
        h2 += (h2 << 5) + Long.hashCode(this.elementInstanceKey);
        h2 += (h2 << 5) + Long.hashCode(this.jobKey);
        h2 += (h2 << 5) + Long.hashCode(this.variableScopeKey);
        return h2;
    }

    public String toString() {
        return "IncidentRecordValue{tenantId=" + this.tenantId + ", errorType=" + (Object)((Object)this.errorType) + ", errorMessage=" + this.errorMessage + ", bpmnProcessId=" + this.bpmnProcessId + ", processDefinitionKey=" + this.processDefinitionKey + ", processInstanceKey=" + this.processInstanceKey + ", elementId=" + this.elementId + ", elementInstanceKey=" + this.elementInstanceKey + ", jobKey=" + this.jobKey + ", variableScopeKey=" + this.variableScopeKey + "}";
    }

    public static ImmutableIncidentRecordValue copyOf(IncidentRecordValue instance) {
        if (instance instanceof ImmutableIncidentRecordValue) {
            return (ImmutableIncidentRecordValue)instance;
        }
        return ImmutableIncidentRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="IncidentRecordValue", generator="Immutables")
    public static final class Builder {
        private String tenantId;
        private ErrorType errorType;
        private String errorMessage;
        private String bpmnProcessId;
        private long processDefinitionKey;
        private long processInstanceKey;
        private String elementId;
        private long elementInstanceKey;
        private long jobKey;
        private long variableScopeKey;

        private Builder() {
        }

        public final Builder from(IncidentRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof IncidentRecordValue) {
                String errorMessageValue;
                instance = (IncidentRecordValue)object;
                String elementIdValue = instance.getElementId();
                if (elementIdValue != null) {
                    this.withElementId(elementIdValue);
                }
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                this.withVariableScopeKey(instance.getVariableScopeKey());
                this.withElementInstanceKey(instance.getElementInstanceKey());
                ErrorType errorTypeValue = instance.getErrorType();
                if (errorTypeValue != null) {
                    this.withErrorType(errorTypeValue);
                }
                if ((errorMessageValue = instance.getErrorMessage()) != null) {
                    this.withErrorMessage(errorMessageValue);
                }
                if ((bits & 2L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
                this.withJobKey(instance.getJobKey());
                String bpmnProcessIdValue = instance.getBpmnProcessId();
                if (bpmnProcessIdValue != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
                this.withProcessDefinitionKey(instance.getProcessDefinitionKey());
            }
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 2L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 2L;
                }
            }
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withErrorType(ErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        public final Builder withErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withProcessDefinitionKey(long processDefinitionKey) {
            this.processDefinitionKey = processDefinitionKey;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withElementId(String elementId) {
            this.elementId = elementId;
            return this;
        }

        public final Builder withElementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            return this;
        }

        public final Builder withJobKey(long jobKey) {
            this.jobKey = jobKey;
            return this;
        }

        public final Builder withVariableScopeKey(long variableScopeKey) {
            this.variableScopeKey = variableScopeKey;
            return this;
        }

        public Builder clear() {
            this.tenantId = null;
            this.errorType = null;
            this.errorMessage = null;
            this.bpmnProcessId = null;
            this.processDefinitionKey = 0L;
            this.processInstanceKey = 0L;
            this.elementId = null;
            this.elementInstanceKey = 0L;
            this.jobKey = 0L;
            this.variableScopeKey = 0L;
            return this;
        }

        public ImmutableIncidentRecordValue build() {
            return new ImmutableIncidentRecordValue(this.tenantId, this.errorType, this.errorMessage, this.bpmnProcessId, this.processDefinitionKey, this.processInstanceKey, this.elementId, this.elementInstanceKey, this.jobKey, this.variableScopeKey);
        }
    }
}

