/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.RecordValueWithVariables;
import io.camunda.zeebe.protocol.record.value.MessageSubscriptionRecordValue;
import io.camunda.zeebe.protocol.record.value.ProcessInstanceRelated;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="MessageSubscriptionRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableMessageSubscriptionRecordValue
implements MessageSubscriptionRecordValue {
    private final Map<String, Object> variables;
    private final String tenantId;
    private final long processInstanceKey;
    private final long elementInstanceKey;
    private final String bpmnProcessId;
    private final String messageName;
    private final String correlationKey;
    private final long messageKey;
    private final boolean interrupting;
    private transient int hashCode;

    private ImmutableMessageSubscriptionRecordValue(Map<String, Object> variables, String tenantId, long processInstanceKey, long elementInstanceKey, String bpmnProcessId, String messageName, String correlationKey, long messageKey, boolean interrupting) {
        this.variables = variables;
        this.tenantId = tenantId;
        this.processInstanceKey = processInstanceKey;
        this.elementInstanceKey = elementInstanceKey;
        this.bpmnProcessId = bpmnProcessId;
        this.messageName = messageName;
        this.correlationKey = correlationKey;
        this.messageKey = messageKey;
        this.interrupting = interrupting;
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.variables;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public long getProcessInstanceKey() {
        return this.processInstanceKey;
    }

    @Override
    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    @Override
    public String getBpmnProcessId() {
        return this.bpmnProcessId;
    }

    @Override
    public String getMessageName() {
        return this.messageName;
    }

    @Override
    public String getCorrelationKey() {
        return this.correlationKey;
    }

    @Override
    public long getMessageKey() {
        return this.messageKey;
    }

    @Override
    public boolean isInterrupting() {
        return this.interrupting;
    }

    public final ImmutableMessageSubscriptionRecordValue withVariables(Map<String, ? extends Object> entries) {
        if (this.variables == entries) {
            return this;
        }
        Map<String, Object> newValue = ImmutableMessageSubscriptionRecordValue.createUnmodifiableMap(false, false, entries);
        return new ImmutableMessageSubscriptionRecordValue(newValue, this.tenantId, this.processInstanceKey, this.elementInstanceKey, this.bpmnProcessId, this.messageName, this.correlationKey, this.messageKey, this.interrupting);
    }

    public final ImmutableMessageSubscriptionRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableMessageSubscriptionRecordValue(this.variables, value, this.processInstanceKey, this.elementInstanceKey, this.bpmnProcessId, this.messageName, this.correlationKey, this.messageKey, this.interrupting);
    }

    public final ImmutableMessageSubscriptionRecordValue withProcessInstanceKey(long value) {
        if (this.processInstanceKey == value) {
            return this;
        }
        return new ImmutableMessageSubscriptionRecordValue(this.variables, this.tenantId, value, this.elementInstanceKey, this.bpmnProcessId, this.messageName, this.correlationKey, this.messageKey, this.interrupting);
    }

    public final ImmutableMessageSubscriptionRecordValue withElementInstanceKey(long value) {
        if (this.elementInstanceKey == value) {
            return this;
        }
        return new ImmutableMessageSubscriptionRecordValue(this.variables, this.tenantId, this.processInstanceKey, value, this.bpmnProcessId, this.messageName, this.correlationKey, this.messageKey, this.interrupting);
    }

    public final ImmutableMessageSubscriptionRecordValue withBpmnProcessId(String value) {
        if (Objects.equals(this.bpmnProcessId, value)) {
            return this;
        }
        return new ImmutableMessageSubscriptionRecordValue(this.variables, this.tenantId, this.processInstanceKey, this.elementInstanceKey, value, this.messageName, this.correlationKey, this.messageKey, this.interrupting);
    }

    public final ImmutableMessageSubscriptionRecordValue withMessageName(String value) {
        if (Objects.equals(this.messageName, value)) {
            return this;
        }
        return new ImmutableMessageSubscriptionRecordValue(this.variables, this.tenantId, this.processInstanceKey, this.elementInstanceKey, this.bpmnProcessId, value, this.correlationKey, this.messageKey, this.interrupting);
    }

    public final ImmutableMessageSubscriptionRecordValue withCorrelationKey(String value) {
        if (Objects.equals(this.correlationKey, value)) {
            return this;
        }
        return new ImmutableMessageSubscriptionRecordValue(this.variables, this.tenantId, this.processInstanceKey, this.elementInstanceKey, this.bpmnProcessId, this.messageName, value, this.messageKey, this.interrupting);
    }

    public final ImmutableMessageSubscriptionRecordValue withMessageKey(long value) {
        if (this.messageKey == value) {
            return this;
        }
        return new ImmutableMessageSubscriptionRecordValue(this.variables, this.tenantId, this.processInstanceKey, this.elementInstanceKey, this.bpmnProcessId, this.messageName, this.correlationKey, value, this.interrupting);
    }

    public final ImmutableMessageSubscriptionRecordValue withInterrupting(boolean value) {
        if (this.interrupting == value) {
            return this;
        }
        return new ImmutableMessageSubscriptionRecordValue(this.variables, this.tenantId, this.processInstanceKey, this.elementInstanceKey, this.bpmnProcessId, this.messageName, this.correlationKey, this.messageKey, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageSubscriptionRecordValue && this.equalTo(0, (ImmutableMessageSubscriptionRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageSubscriptionRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.variables.equals(another.variables) && Objects.equals(this.tenantId, another.tenantId) && this.processInstanceKey == another.processInstanceKey && this.elementInstanceKey == another.elementInstanceKey && Objects.equals(this.bpmnProcessId, another.bpmnProcessId) && Objects.equals(this.messageName, another.messageName) && Objects.equals(this.correlationKey, another.correlationKey) && this.messageKey == another.messageKey && this.interrupting == another.interrupting;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + this.variables.hashCode();
        h2 += (h2 << 5) + Objects.hashCode(this.tenantId);
        h2 += (h2 << 5) + Long.hashCode(this.processInstanceKey);
        h2 += (h2 << 5) + Long.hashCode(this.elementInstanceKey);
        h2 += (h2 << 5) + Objects.hashCode(this.bpmnProcessId);
        h2 += (h2 << 5) + Objects.hashCode(this.messageName);
        h2 += (h2 << 5) + Objects.hashCode(this.correlationKey);
        h2 += (h2 << 5) + Long.hashCode(this.messageKey);
        h2 += (h2 << 5) + Boolean.hashCode(this.interrupting);
        return h2;
    }

    public String toString() {
        return "MessageSubscriptionRecordValue{variables=" + this.variables + ", tenantId=" + this.tenantId + ", processInstanceKey=" + this.processInstanceKey + ", elementInstanceKey=" + this.elementInstanceKey + ", bpmnProcessId=" + this.bpmnProcessId + ", messageName=" + this.messageName + ", correlationKey=" + this.correlationKey + ", messageKey=" + this.messageKey + ", interrupting=" + this.interrupting + "}";
    }

    public static ImmutableMessageSubscriptionRecordValue copyOf(MessageSubscriptionRecordValue instance) {
        if (instance instanceof ImmutableMessageSubscriptionRecordValue) {
            return (ImmutableMessageSubscriptionRecordValue)instance;
        }
        return ImmutableMessageSubscriptionRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    @ImmutableProtocol.Builder
    @Generated(from="MessageSubscriptionRecordValue", generator="Immutables")
    public static final class Builder {
        private Map<String, Object> variables = new LinkedHashMap<String, Object>();
        private String tenantId;
        private long processInstanceKey;
        private long elementInstanceKey;
        private String bpmnProcessId;
        private String messageName;
        private String correlationKey;
        private long messageKey;
        private boolean interrupting;

        private Builder() {
        }

        public final Builder from(ProcessInstanceRelated instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(RecordValueWithVariables instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageSubscriptionRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof ProcessInstanceRelated) {
                instance = (ProcessInstanceRelated)object;
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 4L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
            }
            if (object instanceof RecordValueWithVariables) {
                instance = (RecordValueWithVariables)object;
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
            }
            if (object instanceof MessageSubscriptionRecordValue) {
                String correlationKeyValue;
                String bpmnProcessIdValue;
                instance = (MessageSubscriptionRecordValue)object;
                String messageNameValue = instance.getMessageName();
                if (messageNameValue != null) {
                    this.withMessageName(messageNameValue);
                }
                if ((bits & 1L) == 0L) {
                    this.withProcessInstanceKey(instance.getProcessInstanceKey());
                    bits |= 1L;
                }
                this.withMessageKey(instance.getMessageKey());
                if ((bits & 2L) == 0L) {
                    this.putAllVariables(instance.getVariables());
                    bits |= 2L;
                }
                this.withElementInstanceKey(instance.getElementInstanceKey());
                this.withInterrupting(instance.isInterrupting());
                if ((bits & 4L) == 0L) {
                    String tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 4L;
                }
                if ((bpmnProcessIdValue = instance.getBpmnProcessId()) != null) {
                    this.withBpmnProcessId(bpmnProcessIdValue);
                }
                if ((correlationKeyValue = instance.getCorrelationKey()) != null) {
                    this.withCorrelationKey(correlationKeyValue);
                }
            }
        }

        public final Builder putVariable(String key, Object value) {
            this.variables.put(key, value);
            return this;
        }

        public final Builder putVariable(Map.Entry<String, ? extends Object> entry) {
            String k = entry.getKey();
            Object v = entry.getValue();
            this.variables.put(k, v);
            return this;
        }

        public final Builder withVariables(Map<String, ? extends Object> entries) {
            this.variables.clear();
            return this.putAllVariables(entries);
        }

        public final Builder putAllVariables(Map<String, ? extends Object> entries) {
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                String k = e.getKey();
                Object v = e.getValue();
                this.variables.put(k, v);
            }
            return this;
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withProcessInstanceKey(long processInstanceKey) {
            this.processInstanceKey = processInstanceKey;
            return this;
        }

        public final Builder withElementInstanceKey(long elementInstanceKey) {
            this.elementInstanceKey = elementInstanceKey;
            return this;
        }

        public final Builder withBpmnProcessId(String bpmnProcessId) {
            this.bpmnProcessId = bpmnProcessId;
            return this;
        }

        public final Builder withMessageName(String messageName) {
            this.messageName = messageName;
            return this;
        }

        public final Builder withCorrelationKey(String correlationKey) {
            this.correlationKey = correlationKey;
            return this;
        }

        public final Builder withMessageKey(long messageKey) {
            this.messageKey = messageKey;
            return this;
        }

        public final Builder withInterrupting(boolean interrupting) {
            this.interrupting = interrupting;
            return this;
        }

        public Builder clear() {
            this.variables.clear();
            this.tenantId = null;
            this.processInstanceKey = 0L;
            this.elementInstanceKey = 0L;
            this.bpmnProcessId = null;
            this.messageName = null;
            this.correlationKey = null;
            this.messageKey = 0L;
            this.interrupting = false;
            return this;
        }

        public ImmutableMessageSubscriptionRecordValue build() {
            return new ImmutableMessageSubscriptionRecordValue(ImmutableMessageSubscriptionRecordValue.createUnmodifiableMap(false, false, this.variables), this.tenantId, this.processInstanceKey, this.elementInstanceKey, this.bpmnProcessId, this.messageName, this.correlationKey, this.messageKey, this.interrupting);
        }
    }
}

