/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.protocol.record.value;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.protocol.record.ImmutableProtocol;
import io.camunda.zeebe.protocol.record.value.ResourceDeletionRecordValue;
import io.camunda.zeebe.protocol.record.value.TenantOwned;
import java.util.Objects;
import org.immutables.value.Generated;

@ImmutableProtocol.Type(builder=Builder.class)
@Generated(from="ResourceDeletionRecordValue", generator="Immutables")
@SuppressFBWarnings
public final class ImmutableResourceDeletionRecordValue
implements ResourceDeletionRecordValue {
    private final String tenantId;
    private final long resourceKey;
    private transient int hashCode;

    private ImmutableResourceDeletionRecordValue(String tenantId, long resourceKey) {
        this.tenantId = tenantId;
        this.resourceKey = resourceKey;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public long getResourceKey() {
        return this.resourceKey;
    }

    public final ImmutableResourceDeletionRecordValue withTenantId(String value) {
        if (Objects.equals(this.tenantId, value)) {
            return this;
        }
        return new ImmutableResourceDeletionRecordValue(value, this.resourceKey);
    }

    public final ImmutableResourceDeletionRecordValue withResourceKey(long value) {
        if (this.resourceKey == value) {
            return this;
        }
        return new ImmutableResourceDeletionRecordValue(this.tenantId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResourceDeletionRecordValue && this.equalTo(0, (ImmutableResourceDeletionRecordValue)another);
    }

    private boolean equalTo(int synthetic, ImmutableResourceDeletionRecordValue another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return Objects.equals(this.tenantId, another.tenantId) && this.resourceKey == another.resourceKey;
    }

    public int hashCode() {
        int h2 = this.hashCode;
        if (h2 == 0) {
            this.hashCode = h2 = this.computeHashCode();
        }
        return h2;
    }

    private int computeHashCode() {
        int h2 = 5381;
        h2 += (h2 << 5) + Objects.hashCode(this.tenantId);
        h2 += (h2 << 5) + Long.hashCode(this.resourceKey);
        return h2;
    }

    public String toString() {
        return "ResourceDeletionRecordValue{tenantId=" + this.tenantId + ", resourceKey=" + this.resourceKey + "}";
    }

    public static ImmutableResourceDeletionRecordValue copyOf(ResourceDeletionRecordValue instance) {
        if (instance instanceof ImmutableResourceDeletionRecordValue) {
            return (ImmutableResourceDeletionRecordValue)instance;
        }
        return ImmutableResourceDeletionRecordValue.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @ImmutableProtocol.Builder
    @Generated(from="ResourceDeletionRecordValue", generator="Immutables")
    public static final class Builder {
        private String tenantId;
        private long resourceKey;

        private Builder() {
        }

        public final Builder from(ResourceDeletionRecordValue instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TenantOwned instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            String tenantIdValue;
            TenantOwned instance;
            long bits = 0L;
            if (object instanceof ResourceDeletionRecordValue) {
                instance = (ResourceDeletionRecordValue)object;
                this.withResourceKey(instance.getResourceKey());
                if ((bits & 1L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof TenantOwned) {
                instance = (TenantOwned)object;
                if ((bits & 1L) == 0L) {
                    tenantIdValue = instance.getTenantId();
                    if (tenantIdValue != null) {
                        this.withTenantId(tenantIdValue);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public final Builder withResourceKey(long resourceKey) {
            this.resourceKey = resourceKey;
            return this;
        }

        public Builder clear() {
            this.tenantId = null;
            this.resourceKey = 0L;
            return this;
        }

        public ImmutableResourceDeletionRecordValue build() {
            return new ImmutableResourceDeletionRecordValue(this.tenantId, this.resourceKey);
        }
    }
}

