/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.camunda.zeebe.scheduler.ActorTask;
import org.agrona.UnsafeAccess;

class ActorTaskQueueNode {
    protected static final long PREV_OFFSET;
    protected static final long NEXT_OFFSET;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Written using UNSAFE (see NEXT_OFFSET usage)")
    volatile ActorTaskQueueNode next;
    @SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="Written using UNSAFE (see PREV_OFFSET usage)")
    volatile ActorTaskQueueNode prev;
    long stateCount;
    ActorTask task;

    ActorTaskQueueNode() {
    }

    void nextOrdered(ActorTaskQueueNode t2) {
        assert (t2 != this);
        UnsafeAccess.UNSAFE.putOrderedObject(this, NEXT_OFFSET, t2);
    }

    void prevOrdered(ActorTaskQueueNode t2) {
        assert (t2 != this);
        UnsafeAccess.UNSAFE.putObjectVolatile(this, PREV_OFFSET, t2);
    }

    public void setTask(ActorTask task) {
        this.task = task;
    }

    static {
        try {
            PREV_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ActorTaskQueueNode.class.getDeclaredField("prev"));
            NEXT_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ActorTaskQueueNode.class.getDeclaredField("next"));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

