/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.agrona.BitUtil;

public final class BoundedArrayQueue<P>
implements Iterable<P>,
Queue<P> {
    protected final Object[] array;
    protected final int capacity;
    protected final int mask;
    protected long head;
    protected long tail;
    protected final BoundedArrayQueueIterator<P> iterator = new BoundedArrayQueueIterator();

    public BoundedArrayQueue(int capacity) {
        this.capacity = BitUtil.findNextPositivePowerOfTwo(capacity);
        this.mask = this.capacity - 1;
        this.head = 0L;
        this.tail = 0L;
        this.array = new Object[capacity];
    }

    @Override
    public int size() {
        return (int)(this.tail - this.head);
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        boolean contains = false;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] != o) continue;
            contains = true;
            break;
        }
        return contains;
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends P> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.head = 0L;
        this.tail = 0L;
        for (int i = 0; i < this.array.length; ++i) {
            this.array[i] = null;
        }
        this.iterator.reset();
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public Iterator<P> iterator() {
        this.iterator.open();
        return this.iterator;
    }

    @Override
    public boolean add(P e) {
        return this.offer(e);
    }

    @Override
    public boolean offer(P object) {
        int remainingSpace = this.capacity - this.size();
        if (remainingSpace > 0) {
            int index = (int)(this.tail & (long)this.mask);
            this.array[index] = object;
            ++this.tail;
            return true;
        }
        return false;
    }

    @Override
    public P remove() {
        P poll = this.poll();
        if (poll == null) {
            throw new NoSuchElementException();
        }
        return poll;
    }

    @Override
    public P poll() {
        int size = this.size();
        Object object = null;
        if (size > 0) {
            int index = (int)(this.head & (long)this.mask);
            object = this.array[index];
            this.array[index] = null;
            ++this.head;
        }
        return (P)object;
    }

    @Override
    public P element() {
        P peek = this.peek();
        if (peek == null) {
            throw new NoSuchElementException();
        }
        return peek;
    }

    @Override
    public P peek() {
        int size = this.size();
        Object object = null;
        if (size > 0) {
            int index = (int)(this.head & (long)this.mask);
            object = this.array[index];
        }
        return (P)object;
    }

    class BoundedArrayQueueIterator<U>
    implements Iterator<U> {
        protected long iteratorPosition;

        BoundedArrayQueueIterator() {
        }

        public void reset() {
            this.iteratorPosition = 0L;
        }

        public void open() {
            this.iteratorPosition = BoundedArrayQueue.this.head;
        }

        @Override
        public boolean hasNext() {
            return this.iteratorPosition < BoundedArrayQueue.this.tail;
        }

        @Override
        public U next() {
            if (this.iteratorPosition == BoundedArrayQueue.this.tail) {
                throw new NoSuchElementException();
            }
            Object object = BoundedArrayQueue.this.array[(int)this.iteratorPosition & BoundedArrayQueue.this.mask];
            ++this.iteratorPosition;
            return (U)object;
        }

        @Override
        public void remove() {
            if (this.iteratorPosition == BoundedArrayQueue.this.tail) {
                throw new NoSuchElementException();
            }
            BoundedArrayQueue.this.array[(int)this.iteratorPosition & BoundedArrayQueue.this.mask] = null;
            ++BoundedArrayQueue.this.head;
        }
    }
}

