/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.scheduler;

import io.camunda.zeebe.scheduler.ActorJob;
import io.camunda.zeebe.scheduler.ActorSubscription;
import io.camunda.zeebe.scheduler.ActorTask;
import io.camunda.zeebe.scheduler.ActorThread;
import io.camunda.zeebe.scheduler.ScheduledTimer;
import java.util.concurrent.TimeUnit;

public final class TimerSubscription
implements ActorSubscription,
ScheduledTimer,
Runnable {
    private final ActorJob job;
    private final ActorTask task;
    private final TimeUnit timeUnit;
    private final long deadline;
    private final boolean isRecurring;
    private volatile boolean isDone = false;
    private volatile boolean isCanceled = false;
    private long timerId = -1L;
    private ActorThread thread;
    private long timerExpiredAt;

    public TimerSubscription(ActorJob job, long deadline, TimeUnit timeUnit, boolean isRecurring) {
        this.job = job;
        this.task = job.getTask();
        this.timeUnit = timeUnit;
        this.deadline = deadline;
        this.isRecurring = isRecurring;
    }

    @Override
    public boolean poll() {
        return this.isDone;
    }

    @Override
    public ActorJob getJob() {
        return this.job;
    }

    @Override
    public boolean isRecurring() {
        return this.isRecurring;
    }

    @Override
    public void onJobCompleted() {
        if (this.isRecurring && !this.isCanceled) {
            this.isDone = false;
            this.submit();
        }
    }

    @Override
    public void cancel() {
        if (!(this.isCanceled || this.isDone && !this.isRecurring)) {
            this.task.onSubscriptionCancelled(this);
            this.isCanceled = true;
            ActorThread current = ActorThread.current();
            if (current != this.thread) {
                this.thread.submittedCallbacks.add(this);
            } else {
                this.run();
            }
        }
    }

    public long getTimerId() {
        return this.timerId;
    }

    public void setTimerId(long timerId) {
        this.timerId = timerId;
    }

    public void submit() {
        this.thread = ActorThread.current();
        this.thread.scheduleTimer(this);
    }

    public long getDeadline() {
        return this.deadline;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void onTimerExpired(TimeUnit timeUnit, long now) {
        if (!this.isCanceled) {
            this.isDone = true;
            this.timerExpiredAt = timeUnit.toNanos(now);
            this.task.tryWakeup();
        }
    }

    @Override
    public void run() {
        this.thread.removeTimer(this);
    }

    public String toString() {
        return "TimerSubscription{timerId=" + this.timerId + ", deadline=" + this.deadline + ", timeUnit=" + String.valueOf((Object)this.timeUnit) + ", isRecurring=" + this.isRecurring + ", isDone=" + this.isDone + ", isCanceled=" + this.isCanceled + ", thread=" + String.valueOf(this.thread) + "}";
    }

    public long getTimerExpiredAt() {
        return this.timerExpiredAt;
    }
}

