/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.api.records;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordMetadataEncoder;
import io.camunda.zeebe.protocol.record.RecordType;

public interface TypedRecord<T extends UnifiedRecordValue>
extends Record<T> {
    @Override
    public long getKey();

    @Override
    public T getValue();

    public int getRequestStreamId();

    public long getRequestId();

    public int getLength();

    default public boolean hasRequestMetadata() {
        return this.getRequestId() != RecordMetadataEncoder.requestIdNullValue() && this.getRequestStreamId() != RecordMetadataEncoder.requestStreamIdNullValue();
    }

    @JsonIgnore
    default public boolean isCommandDistributed() {
        boolean isCommand = this.getRecordType().equals((Object)RecordType.COMMAND);
        long key = this.getKey();
        return isCommand && key != -1L && Protocol.decodePartitionId(key) != this.getPartitionId();
    }
}

