/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl;

import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.exception.UnrecoverableException;

final class NoSuchProcessorException
extends UnrecoverableException {
    private NoSuchProcessorException(String message) {
        super(message);
    }

    public static NoSuchProcessorException forRecord(TypedRecord<?> record) {
        String message = switch (record.getRecordType()) {
            default -> throw new MatchException(null, null);
            case RecordType.EVENT -> "No processor registered for event type %s".formatted(new Object[]{record.getValueType()});
            case RecordType.COMMAND -> "No processor registered for command type %s".formatted(new Object[]{record.getValueType()});
            case RecordType.COMMAND_REJECTION, RecordType.SBE_UNKNOWN, RecordType.NULL_VAL -> "No processor registered for record type %s".formatted(new Object[]{record.getRecordType()});
        };
        return new NoSuchProcessorException(message);
    }
}

