/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.records;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.stream.api.records.ExceededBatchRecordSizeException;
import io.camunda.zeebe.stream.api.records.ImmutableRecordBatch;
import io.camunda.zeebe.stream.api.records.MutableRecordBatch;
import io.camunda.zeebe.stream.api.records.RecordBatchSizePredicate;
import io.camunda.zeebe.stream.impl.records.RecordBatchEntry;
import io.camunda.zeebe.util.Either;
import io.camunda.zeebe.util.buffer.BufferWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;

public final class RecordBatch
implements MutableRecordBatch {
    final List<RecordBatchEntry> recordBatchEntries = new ArrayList<RecordBatchEntry>();
    private int batchSize;
    private final RecordBatchSizePredicate recordBatchSizePredicate;

    public RecordBatch(RecordBatchSizePredicate recordBatchSizePredicate) {
        this.recordBatchSizePredicate = recordBatchSizePredicate;
    }

    public static ImmutableRecordBatch empty() {
        return new RecordBatch((c, s2) -> false);
    }

    @Override
    public Either<RuntimeException, Void> appendRecord(long key, RecordMetadata metadata, int sourceIndex, BufferWriter valueWriter) {
        RecordBatchEntry recordBatchEntry = RecordBatchEntry.createEntry(key, metadata, sourceIndex, valueWriter);
        int entryLength = recordBatchEntry.getLength();
        if (!this.recordBatchSizePredicate.test(this.recordBatchEntries.size() + 1, this.batchSize + entryLength)) {
            return Either.left(new ExceededBatchRecordSizeException(recordBatchEntry, entryLength, this.recordBatchEntries.size(), this.batchSize));
        }
        this.recordBatchEntries.add(recordBatchEntry);
        this.batchSize += entryLength;
        return Either.right(null);
    }

    @Override
    public boolean canAppendRecordOfLength(int recordLength) {
        return this.recordBatchSizePredicate.test(this.recordBatchEntries.size() + 1, this.batchSize + recordLength);
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Iterator<RecordBatchEntry> iterator() {
        return this.recordBatchEntries.iterator();
    }

    @Override
    public void forEach(Consumer<? super RecordBatchEntry> action) {
        this.recordBatchEntries.forEach(action);
    }

    @Override
    public Spliterator<RecordBatchEntry> spliterator() {
        return this.recordBatchEntries.spliterator();
    }

    @Override
    public List<LogAppendEntry> entries() {
        return Collections.unmodifiableList(this.recordBatchEntries);
    }
}

