/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.records;

import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.stream.impl.TypedEventRegistry;
import io.camunda.zeebe.util.ReflectUtil;
import io.camunda.zeebe.util.buffer.BufferWriter;
import org.agrona.concurrent.UnsafeBuffer;

public record RecordBatchEntry(RecordMetadata recordMetadata, long key, int sourceIndex, UnifiedRecordValue unifiedRecordValue) implements LogAppendEntry
{
    @Override
    public UnifiedRecordValue recordValue() {
        return this.unifiedRecordValue;
    }

    public static RecordBatchEntry createEntry(long key, RecordMetadata metadata, int sourceIndex, BufferWriter valueWriter) {
        byte[] bytes = new byte[valueWriter.getLength()];
        UnsafeBuffer recordValueBuffer = new UnsafeBuffer(bytes);
        valueWriter.write(recordValueBuffer, 0);
        UnifiedRecordValue unifiedRecordValue = ReflectUtil.newInstance(TypedEventRegistry.EVENT_REGISTRY.get((Object)metadata.getValueType()));
        unifiedRecordValue.wrap(recordValueBuffer, 0, recordValueBuffer.capacity());
        return new RecordBatchEntry(metadata, key, sourceIndex, unifiedRecordValue);
    }
}

