/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.records;

import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.stream.impl.TypedEventRegistry;
import io.camunda.zeebe.util.ReflectUtil;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;

public final class RecordValues {
    private final Map<ValueType, UnifiedRecordValue> eventCache;

    public RecordValues() {
        EnumMap cache = new EnumMap(ValueType.class);
        TypedEventRegistry.EVENT_REGISTRY.forEach((t2, c) -> cache.put((ValueType)((Object)t2), (UnifiedRecordValue)ReflectUtil.newInstance(c)));
        this.eventCache = Collections.unmodifiableMap(cache);
    }

    public UnifiedRecordValue readRecordValue(LoggedEvent event, ValueType valueType) {
        UnifiedRecordValue value = this.eventCache.get((Object)valueType);
        if (value != null) {
            value.reset();
            event.readValue(value);
        }
        return value;
    }
}

