/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.stream.impl.records;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.camunda.zeebe.logstreams.log.LoggedEvent;
import io.camunda.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RejectionType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.stream.impl.records.CopiedRecords;
import io.camunda.zeebe.util.StringUtil;
import java.util.Map;

public final class TypedRecordImpl
implements TypedRecord {
    private final int partitionId;
    private LoggedEvent rawEvent;
    private RecordMetadata metadata;
    private UnifiedRecordValue value;

    public TypedRecordImpl(int partitionId) {
        this.partitionId = partitionId;
    }

    public void wrap(LoggedEvent rawEvent, RecordMetadata metadata, UnifiedRecordValue value) {
        this.rawEvent = rawEvent;
        this.metadata = metadata;
        this.value = value;
    }

    @JsonIgnore
    public RecordMetadata getMetadata() {
        return this.metadata;
    }

    @Override
    public long getPosition() {
        return this.rawEvent.getPosition();
    }

    @Override
    public long getSourceRecordPosition() {
        return this.rawEvent.getSourceEventPosition();
    }

    @Override
    public long getTimestamp() {
        return this.rawEvent.getTimestamp();
    }

    @Override
    public Intent getIntent() {
        return this.metadata.getIntent();
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public RecordType getRecordType() {
        return this.metadata.getRecordType();
    }

    @Override
    public RejectionType getRejectionType() {
        return this.metadata.getRejectionType();
    }

    @Override
    public String getRejectionReason() {
        return this.metadata.getRejectionReason();
    }

    @Override
    public String getBrokerVersion() {
        return this.metadata.getBrokerVersion().toString();
    }

    @Override
    public Map<String, Object> getAuthorizations() {
        return this.metadata.getAuthorization().toDecodedMap();
    }

    @Override
    public int getRecordVersion() {
        return this.metadata.getRecordVersion();
    }

    @Override
    public ValueType getValueType() {
        return this.metadata.getValueType();
    }

    @Override
    public Record copyOf() {
        return CopiedRecords.createCopiedRecord(this.getPartitionId(), this.rawEvent);
    }

    @Override
    public long getKey() {
        return this.rawEvent.getKey();
    }

    @Override
    public UnifiedRecordValue getValue() {
        return this.value;
    }

    @Override
    @JsonIgnore
    public int getRequestStreamId() {
        return this.metadata.getRequestStreamId();
    }

    @Override
    @JsonIgnore
    public long getRequestId() {
        return this.metadata.getRequestId();
    }

    @Override
    @JsonIgnore
    public int getLength() {
        return this.metadata.getLength() + this.value.getLength();
    }

    @Override
    public String toJson() {
        return MsgPackConverter.convertJsonSerializableObjectToJson(this);
    }

    public String toString() {
        return "TypedRecordImpl{metadata=" + String.valueOf(this.metadata) + ", value=" + StringUtil.limitString(this.value.toString(), 1024) + "}";
    }
}

