/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public record SemanticVersion(int major, int minor, int patch, String preRelease, String buildMetadata) implements Comparable<SemanticVersion>
{
    private static final Pattern PATTERN = Pattern.compile("^(?<major>0|[1-9]\\d*)\\.(?<minor>0|[1-9]\\d*)\\.(?<patch>0|[1-9]\\d*)(?:-(?<preRelease>(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+(?<buildMetadata>[0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");

    public SemanticVersion {
        if (major < 0) {
            throw new IllegalArgumentException("Major version must be non-negative");
        }
        if (minor < 0) {
            throw new IllegalArgumentException("Minor version must be non-negative");
        }
        if (patch < 0) {
            throw new IllegalArgumentException("Patch version must be non-negative");
        }
    }

    public static Optional<SemanticVersion> parse(String version) {
        if (version == null) {
            return Optional.empty();
        }
        Matcher matcher = PATTERN.matcher(version);
        if (matcher.matches()) {
            int major = Integer.parseInt(matcher.group("major"));
            int minor = Integer.parseInt(matcher.group("minor"));
            int patch = Integer.parseInt(matcher.group("patch"));
            String preRelease = matcher.group("preRelease");
            String buildMetadata = matcher.group("buildMetadata");
            return Optional.of(new SemanticVersion(major, minor, patch, preRelease, buildMetadata));
        }
        return Optional.empty();
    }

    @Override
    public int compareTo(SemanticVersion other) {
        if (this.major != other.major) {
            return Integer.compare(this.major, other.major);
        }
        if (this.minor != other.minor) {
            return Integer.compare(this.minor, other.minor);
        }
        if (this.patch != other.patch) {
            return Integer.compare(this.patch, other.patch);
        }
        return this.comparePreRelease(other);
    }

    private int comparePreRelease(SemanticVersion other) {
        if (this.preRelease == null && other.preRelease == null) {
            return 0;
        }
        if (this.preRelease != null && other.preRelease == null) {
            return -1;
        }
        if (this.preRelease == null && other.preRelease != null) {
            return 1;
        }
        String[] preReleaseParts = this.preRelease.split("\\.");
        String[] otherPreReleaseParts = other.preRelease.split("\\.");
        for (int i = 0; i < Math.min(preReleaseParts.length, otherPreReleaseParts.length); ++i) {
            String thisPart = preReleaseParts[i];
            String otherPart = otherPreReleaseParts[i];
            if (StringUtils.isNumeric(thisPart) && StringUtils.isNumeric(otherPart)) {
                int otherNumericPart;
                int thisNumericPart = Integer.parseInt(thisPart);
                if (thisNumericPart == (otherNumericPart = Integer.parseInt(otherPart))) continue;
                return Integer.compare(thisNumericPart, otherNumericPart);
            }
            if (StringUtils.isNumeric(thisPart)) {
                return -1;
            }
            if (StringUtils.isNumeric(otherPart)) {
                return 1;
            }
            int comparison = thisPart.compareTo(otherPart);
            if (comparison == 0) continue;
            return comparison;
        }
        return Integer.compare(preReleaseParts.length, otherPreReleaseParts.length);
    }

    @Override
    public String toString() {
        String version = this.major + "." + this.minor + "." + this.patch;
        if (this.preRelease != null) {
            return version + "-" + this.preRelease;
        }
        return version;
    }
}

