/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.allocation;

import io.camunda.zeebe.util.allocation.AllocatedBuffer;
import io.camunda.zeebe.util.allocation.AllocatedDirectBuffer;
import io.camunda.zeebe.util.allocation.BufferAllocator;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicLong;
import org.agrona.BufferUtil;

public final class DirectBufferAllocator
implements BufferAllocator {
    private static final AtomicLong ALLOCATED_MEMORY = new AtomicLong();

    @Override
    public AllocatedBuffer allocate(int capacity) {
        AllocatedDirectBuffer buffer = new AllocatedDirectBuffer(ByteBuffer.allocateDirect(capacity), DirectBufferAllocator::onFree);
        ALLOCATED_MEMORY.addAndGet(capacity);
        return buffer;
    }

    private static void onFree(AllocatedDirectBuffer buffer) {
        ALLOCATED_MEMORY.addAndGet(-buffer.capacity());
        BufferUtil.free(buffer.rawBuffer);
    }

    public static long getAllocatedMemoryInKb() {
        return ALLOCATED_MEMORY.get() / 1024L;
    }
}

