/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.util.health;

import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;

public final class MemoryHealthIndicator
implements HealthIndicator {
    private final double threshold;

    public MemoryHealthIndicator(double threshold) {
        if (threshold <= 0.0 || threshold >= 1.0) {
            throw new IllegalArgumentException("Threshold must be a value in the interval ]0,1[");
        }
        this.threshold = threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    @Override
    public Health health() {
        if (this.getAvailableMemoryPercentageCurrently() > this.threshold) {
            return Health.up().withDetail("threshold", this.threshold).build();
        }
        return Health.down().withDetail("threshold", this.threshold).build();
    }

    private double getAvailableMemoryPercentageCurrently() {
        Runtime runtime = Runtime.getRuntime();
        long freeMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long maxMemory = runtime.maxMemory();
        long notYetAllocatedMemory = maxMemory - totalMemory;
        long availableMemory = freeMemory + notYetAllocatedMemory;
        return (double)availableMemory / (double)maxMemory;
    }
}

