/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.bpm.model.xml.impl.type.child;

import java.util.Collection;
import java.util.Iterator;
import org.camunda.bpm.model.xml.Model;
import org.camunda.bpm.model.xml.UnsupportedModelOperationException;
import org.camunda.bpm.model.xml.impl.instance.ModelElementInstanceImpl;
import org.camunda.bpm.model.xml.impl.type.ModelElementTypeImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;
import org.camunda.bpm.model.xml.instance.DomElement;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.camunda.bpm.model.xml.type.child.ChildElementCollection;

public class ChildElementCollectionImpl<T extends ModelElementInstance>
implements ChildElementCollection<T> {
    protected final Class<T> childElementTypeClass;
    private final ModelElementType parentElementType;
    private int minOccurs = 0;
    protected int maxOccurs = -1;
    private boolean isMutable = true;

    public ChildElementCollectionImpl(Class<T> childElementTypeClass, ModelElementTypeImpl parentElementType) {
        this.childElementTypeClass = childElementTypeClass;
        this.parentElementType = parentElementType;
    }

    public void setImmutable() {
        this.setMutable(false);
    }

    public void setMutable(boolean isMutable) {
        this.isMutable = isMutable;
    }

    @Override
    public boolean isImmutable() {
        return !this.isMutable;
    }

    private Collection<DomElement> getView(ModelElementInstanceImpl modelElement) {
        return modelElement.getDomElement().getChildElementsByType(modelElement.getModelInstance(), this.childElementTypeClass);
    }

    @Override
    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    @Override
    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public ModelElementType getChildElementType(Model model) {
        return model.getType(this.childElementTypeClass);
    }

    @Override
    public Class<T> getChildElementTypeClass() {
        return this.childElementTypeClass;
    }

    @Override
    public ModelElementType getParentElementType() {
        return this.parentElementType;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    private void performAddOperation(ModelElementInstanceImpl modelElement, T e) {
        modelElement.addChildElement((ModelElementInstance)e);
    }

    private boolean performRemoveOperation(ModelElementInstanceImpl modelElement, Object e) {
        return modelElement.removeChildElement((ModelElementInstanceImpl)e);
    }

    private void performClearOperation(ModelElementInstanceImpl modelElement, Collection<DomElement> elementsToRemove) {
        Collection<ModelElementInstance> modelElements = ModelUtil.getModelElementCollection(elementsToRemove, modelElement.getModelInstance());
        for (ModelElementInstance element : modelElements) {
            modelElement.removeChildElement(element);
        }
    }

    @Override
    public Collection<T> get(ModelElementInstance element) {
        final ModelElementInstanceImpl modelElement = (ModelElementInstanceImpl)element;
        return new Collection<T>(){

            @Override
            public boolean contains(Object o) {
                if (o == null) {
                    return false;
                }
                if (!(o instanceof ModelElementInstanceImpl)) {
                    return false;
                }
                return ChildElementCollectionImpl.this.getView(modelElement).contains(((ModelElementInstanceImpl)o).getDomElement());
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object elementToCheck : c) {
                    if (this.contains(elementToCheck)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean isEmpty() {
                return ChildElementCollectionImpl.this.getView(modelElement).isEmpty();
            }

            @Override
            public Iterator<T> iterator() {
                Collection modelElementCollection = ModelUtil.getModelElementCollection(ChildElementCollectionImpl.this.getView(modelElement), modelElement.getModelInstance());
                return modelElementCollection.iterator();
            }

            @Override
            public Object[] toArray() {
                Collection modelElementCollection = ModelUtil.getModelElementCollection(ChildElementCollectionImpl.this.getView(modelElement), modelElement.getModelInstance());
                return modelElementCollection.toArray();
            }

            @Override
            public <U> U[] toArray(U[] a) {
                Collection<U> modelElementCollection = ModelUtil.getModelElementCollection(ChildElementCollectionImpl.this.getView(modelElement), modelElement.getModelInstance());
                return modelElementCollection.toArray(a);
            }

            @Override
            public int size() {
                return ChildElementCollectionImpl.this.getView(modelElement).size();
            }

            @Override
            public boolean add(T e) {
                if (!ChildElementCollectionImpl.this.isMutable) {
                    throw new UnsupportedModelOperationException("add()", "collection is immutable");
                }
                ChildElementCollectionImpl.this.performAddOperation(modelElement, e);
                return true;
            }

            @Override
            public boolean addAll(Collection<? extends T> c) {
                if (!ChildElementCollectionImpl.this.isMutable) {
                    throw new UnsupportedModelOperationException("addAll()", "collection is immutable");
                }
                boolean result = false;
                for (ModelElementInstance t2 : c) {
                    result |= this.add((T)t2);
                }
                return result;
            }

            @Override
            public void clear() {
                if (!ChildElementCollectionImpl.this.isMutable) {
                    throw new UnsupportedModelOperationException("clear()", "collection is immutable");
                }
                Collection view = ChildElementCollectionImpl.this.getView(modelElement);
                ChildElementCollectionImpl.this.performClearOperation(modelElement, view);
            }

            @Override
            public boolean remove(Object e) {
                if (!ChildElementCollectionImpl.this.isMutable) {
                    throw new UnsupportedModelOperationException("remove()", "collection is immutable");
                }
                ModelUtil.ensureInstanceOf(e, ModelElementInstanceImpl.class);
                return ChildElementCollectionImpl.this.performRemoveOperation(modelElement, e);
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                if (!ChildElementCollectionImpl.this.isMutable) {
                    throw new UnsupportedModelOperationException("removeAll()", "collection is immutable");
                }
                boolean result = false;
                for (Object t2 : c) {
                    result |= this.remove(t2);
                }
                return result;
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                throw new UnsupportedModelOperationException("retainAll()", "not implemented");
            }
        };
    }
}

