/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans.factory.aot;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import org.springframework.aot.generate.GeneratedMethods;
import org.springframework.aot.generate.ValueCodeGenerator;
import org.springframework.aot.generate.ValueCodeGeneratorDelegates;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.aot.BeanDefinitionPropertyValueCodeGeneratorDelegates;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.AutowireCandidateQualifier;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.javapoet.CodeBlock;
import org.springframework.lang.Nullable;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

class BeanDefinitionPropertiesCodeGenerator {
    private static final RootBeanDefinition DEFAULT_BEAN_DEFINITION = new RootBeanDefinition();
    private static final String BEAN_DEFINITION_VARIABLE = "beanDefinition";
    private final RuntimeHints hints;
    private final Predicate<String> attributeFilter;
    private final ValueCodeGenerator valueCodeGenerator;

    BeanDefinitionPropertiesCodeGenerator(RuntimeHints hints, Predicate<String> attributeFilter, GeneratedMethods generatedMethods, List<ValueCodeGenerator.Delegate> additionalDelegates, BiFunction<String, Object, CodeBlock> customValueCodeGenerator) {
        this.hints = hints;
        this.attributeFilter = attributeFilter;
        ArrayList<ValueCodeGenerator.Delegate> allDelegates = new ArrayList<ValueCodeGenerator.Delegate>();
        allDelegates.add((valueCodeGenerator, value) -> (CodeBlock)customValueCodeGenerator.apply(PropertyNamesStack.peek(), value));
        allDelegates.addAll(additionalDelegates);
        allDelegates.addAll(BeanDefinitionPropertyValueCodeGeneratorDelegates.INSTANCES);
        allDelegates.addAll(ValueCodeGeneratorDelegates.INSTANCES);
        this.valueCodeGenerator = ValueCodeGenerator.with(allDelegates).scoped(generatedMethods);
    }

    CodeBlock generateCode(RootBeanDefinition beanDefinition) {
        CodeBlock.Builder code = CodeBlock.builder();
        this.addStatementForValue(code, beanDefinition, BeanDefinition::isPrimary, "$L.setPrimary($L)");
        this.addStatementForValue(code, beanDefinition, BeanDefinition::getScope, this::hasScope, "$L.setScope($S)");
        this.addStatementForValue(code, beanDefinition, BeanDefinition::getDependsOn, this::hasDependsOn, "$L.setDependsOn($L)", this::toStringVarArgs);
        this.addStatementForValue(code, beanDefinition, BeanDefinition::isAutowireCandidate, "$L.setAutowireCandidate($L)");
        this.addStatementForValue(code, beanDefinition, BeanDefinition::getRole, this::hasRole, "$L.setRole($L)", this::toRole);
        this.addStatementForValue(code, beanDefinition, AbstractBeanDefinition::getLazyInit, "$L.setLazyInit($L)");
        this.addStatementForValue(code, beanDefinition, AbstractBeanDefinition::isSynthetic, "$L.setSynthetic($L)");
        this.addInitDestroyMethods(code, beanDefinition, beanDefinition.getInitMethodNames(), "$L.setInitMethodNames($L)");
        this.addInitDestroyMethods(code, beanDefinition, beanDefinition.getDestroyMethodNames(), "$L.setDestroyMethodNames($L)");
        this.addConstructorArgumentValues(code, beanDefinition);
        this.addPropertyValues(code, beanDefinition);
        this.addAttributes(code, beanDefinition);
        this.addQualifiers(code, beanDefinition);
        return code.build();
    }

    private void addInitDestroyMethods(CodeBlock.Builder code, AbstractBeanDefinition beanDefinition, @Nullable String[] methodNames, String format) {
        this.hints.reflection().registerType(TypeReference.of("org.reactivestreams.Publisher"), new MemberCategory[0]);
        if (!ObjectUtils.isEmpty(methodNames)) {
            Class<?> beanType = ClassUtils.getUserClass(beanDefinition.getResolvableType().toClass());
            Arrays.stream(methodNames).forEach(methodName -> this.addInitDestroyHint(beanType, (String)methodName));
            CodeBlock arguments = Arrays.stream(methodNames).map(name -> CodeBlock.of("$S", name)).collect(CodeBlock.joining(", "));
            code.addStatement(format, BEAN_DEFINITION_VARIABLE, arguments);
        }
    }

    private void addInitDestroyHint(Class<?> beanUserClass, String methodName) {
        Method method;
        Class<?> methodDeclaringClass = beanUserClass;
        int indexOfDot = methodName.lastIndexOf(46);
        if (indexOfDot > 0) {
            String className = methodName.substring(0, indexOfDot);
            methodName = methodName.substring(indexOfDot + 1);
            if (!beanUserClass.getName().equals(className)) {
                try {
                    methodDeclaringClass = ClassUtils.forName(className, beanUserClass.getClassLoader());
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Failed to load Class [" + className + "] from ClassLoader [" + beanUserClass.getClassLoader() + "]", ex);
                }
            }
        }
        if ((method = ReflectionUtils.findMethod(methodDeclaringClass, methodName)) != null) {
            this.hints.reflection().registerMethod(method, ExecutableMode.INVOKE);
            Method interfaceMethod = ClassUtils.getInterfaceMethodIfPossible(method, beanUserClass);
            if (!interfaceMethod.equals(method)) {
                this.hints.reflection().registerMethod(interfaceMethod, ExecutableMode.INVOKE);
            }
        }
    }

    private void addConstructorArgumentValues(CodeBlock.Builder code, BeanDefinition beanDefinition) {
        List<ConstructorArgumentValues.ValueHolder> genericValues;
        ConstructorArgumentValues constructorValues = beanDefinition.getConstructorArgumentValues();
        Map<Integer, ConstructorArgumentValues.ValueHolder> indexedValues = constructorValues.getIndexedArgumentValues();
        if (!indexedValues.isEmpty()) {
            indexedValues.forEach((index, valueHolder) -> {
                Object value = valueHolder.getValue();
                CodeBlock valueCode = this.castIfNecessary(value == null, Object.class, this.generateValue(valueHolder.getName(), value));
                code.addStatement("$L.getConstructorArgumentValues().addIndexedArgumentValue($L, $L)", BEAN_DEFINITION_VARIABLE, index, valueCode);
            });
        }
        if (!(genericValues = constructorValues.getGenericArgumentValues()).isEmpty()) {
            genericValues.forEach(valueHolder -> {
                String valueName = valueHolder.getName();
                CodeBlock valueCode = this.generateValue(valueName, valueHolder.getValue());
                if (valueName != null) {
                    CodeBlock valueTypeCode = this.valueCodeGenerator.generateCode(valueHolder.getType());
                    code.addStatement("$L.getConstructorArgumentValues().addGenericArgumentValue(new $T($L, $L, $S))", BEAN_DEFINITION_VARIABLE, ConstructorArgumentValues.ValueHolder.class, valueCode, valueTypeCode, valueName);
                } else if (valueHolder.getType() != null) {
                    code.addStatement("$L.getConstructorArgumentValues().addGenericArgumentValue($L, $S)", BEAN_DEFINITION_VARIABLE, valueCode, valueHolder.getType());
                } else {
                    code.addStatement("$L.getConstructorArgumentValues().addGenericArgumentValue($L)", BEAN_DEFINITION_VARIABLE, valueCode);
                }
            });
        }
    }

    private void addPropertyValues(CodeBlock.Builder code, RootBeanDefinition beanDefinition) {
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        if (!propertyValues.isEmpty()) {
            Class<?> infrastructureType = this.getInfrastructureType(beanDefinition);
            Map writeMethods = infrastructureType != Object.class ? this.getWriteMethods(infrastructureType) : Collections.emptyMap();
            for (PropertyValue propertyValue : propertyValues) {
                String name = propertyValue.getName();
                CodeBlock valueCode = this.generateValue(name, propertyValue.getValue());
                code.addStatement("$L.getPropertyValues().addPropertyValue($S, $L)", BEAN_DEFINITION_VARIABLE, name, valueCode);
                Method writeMethod = (Method)writeMethods.get(name);
                if (writeMethod == null) continue;
                this.registerReflectionHints(beanDefinition, writeMethod);
            }
        }
    }

    private void registerReflectionHints(RootBeanDefinition beanDefinition, Method writeMethod) {
        this.hints.reflection().registerMethod(writeMethod, ExecutableMode.INVOKE);
        for (Class<?> searchType = beanDefinition.getTargetType(); searchType != null && searchType != writeMethod.getDeclaringClass(); searchType = searchType.getSuperclass()) {
            this.hints.reflection().registerType(searchType, MemberCategory.DECLARED_FIELDS);
        }
        this.hints.reflection().registerType(writeMethod.getDeclaringClass(), MemberCategory.DECLARED_FIELDS);
    }

    private void addQualifiers(CodeBlock.Builder code, RootBeanDefinition beanDefinition) {
        Set<AutowireCandidateQualifier> qualifiers = beanDefinition.getQualifiers();
        if (!qualifiers.isEmpty()) {
            for (AutowireCandidateQualifier qualifier : qualifiers) {
                ArrayList<CodeBlock> arguments = new ArrayList<CodeBlock>();
                arguments.add(CodeBlock.of("$S", qualifier.getTypeName()));
                Object qualifierValue = qualifier.getAttribute("value");
                if (qualifierValue != null) {
                    arguments.add(this.generateValue("value", qualifierValue));
                }
                code.addStatement("$L.addQualifier(new $T($L))", BEAN_DEFINITION_VARIABLE, AutowireCandidateQualifier.class, CodeBlock.join(arguments, ", "));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CodeBlock generateValue(@Nullable String name, @Nullable Object value) {
        try {
            PropertyNamesStack.push(name);
            CodeBlock codeBlock = this.valueCodeGenerator.generateCode(value);
            return codeBlock;
        }
        finally {
            PropertyNamesStack.pop();
        }
    }

    private Class<?> getInfrastructureType(RootBeanDefinition beanDefinition) {
        Class<?> beanClass;
        if (beanDefinition.hasBeanClass() && FactoryBean.class.isAssignableFrom(beanClass = beanDefinition.getBeanClass())) {
            return beanClass;
        }
        return ClassUtils.getUserClass(beanDefinition.getResolvableType().toClass());
    }

    private Map<String, Method> getWriteMethods(Class<?> clazz) {
        HashMap<String, Method> writeMethods = new HashMap<String, Method>();
        for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors(clazz)) {
            writeMethods.put(propertyDescriptor.getName(), propertyDescriptor.getWriteMethod());
        }
        return Collections.unmodifiableMap(writeMethods);
    }

    private void addAttributes(CodeBlock.Builder code, BeanDefinition beanDefinition) {
        Object[] attributeNames = beanDefinition.attributeNames();
        if (!ObjectUtils.isEmpty(attributeNames)) {
            for (Object attributeName : attributeNames) {
                if (!this.attributeFilter.test((String)attributeName)) continue;
                CodeBlock value = this.valueCodeGenerator.generateCode(beanDefinition.getAttribute((String)attributeName));
                code.addStatement("$L.setAttribute($S, $L)", BEAN_DEFINITION_VARIABLE, attributeName, value);
            }
        }
    }

    private boolean hasScope(String defaultValue, String actualValue) {
        return StringUtils.hasText(actualValue) && !"singleton".equals(actualValue);
    }

    private boolean hasDependsOn(String[] defaultValue, String[] actualValue) {
        return !ObjectUtils.isEmpty(actualValue);
    }

    private boolean hasRole(int defaultValue, int actualValue) {
        return actualValue != 0;
    }

    private CodeBlock toStringVarArgs(String[] strings) {
        return Arrays.stream(strings).map(string -> CodeBlock.of("$S", string)).collect(CodeBlock.joining(","));
    }

    private Object toRole(int value) {
        return switch (value) {
            case 2 -> CodeBlock.builder().add("$T.ROLE_INFRASTRUCTURE", BeanDefinition.class).build();
            case 1 -> CodeBlock.builder().add("$T.ROLE_SUPPORT", BeanDefinition.class).build();
            default -> value;
        };
    }

    private <B extends BeanDefinition, T> void addStatementForValue(CodeBlock.Builder code, BeanDefinition beanDefinition, Function<B, T> getter2, String format) {
        this.addStatementForValue(code, beanDefinition, getter2, (defaultValue, actualValue) -> !Objects.equals(defaultValue, actualValue), format);
    }

    private <B extends BeanDefinition, T> void addStatementForValue(CodeBlock.Builder code, BeanDefinition beanDefinition, Function<B, T> getter2, BiPredicate<T, T> filter, String format) {
        this.addStatementForValue(code, beanDefinition, getter2, filter, format, actualValue -> actualValue);
    }

    private <B extends BeanDefinition, T> void addStatementForValue(CodeBlock.Builder code, BeanDefinition beanDefinition, Function<B, T> getter2, BiPredicate<T, T> filter, String format, Function<T, Object> formatter) {
        T actualValue;
        T defaultValue = getter2.apply(DEFAULT_BEAN_DEFINITION);
        if (filter.test(defaultValue, actualValue = getter2.apply(beanDefinition))) {
            code.addStatement(format, BEAN_DEFINITION_VARIABLE, formatter.apply(actualValue));
        }
    }

    private CodeBlock castIfNecessary(boolean castNecessary, Class<?> castType, CodeBlock valueCode) {
        return castNecessary ? CodeBlock.of("($T) $L", castType, valueCode) : valueCode;
    }

    static class PropertyNamesStack {
        private static final ThreadLocal<ArrayDeque<String>> threadLocal = ThreadLocal.withInitial(ArrayDeque::new);

        PropertyNamesStack() {
        }

        static void push(@Nullable String name) {
            String valueToSet = name != null ? name : "";
            threadLocal.get().push(valueToSet);
        }

        static void pop() {
            threadLocal.get().pop();
        }

        @Nullable
        static String peek() {
            String value = threadLocal.get().peek();
            return "".equals(value) ? null : value;
        }
    }
}

