/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.export.otlp;

import io.micrometer.core.instrument.Clock;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpMeterRegistry;
import org.springframework.boot.actuate.autoconfigure.metrics.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.MetricsAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.metrics.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpProperties;
import org.springframework.boot.actuate.autoconfigure.metrics.export.otlp.OtlpPropertiesConfigAdapter;
import org.springframework.boot.actuate.autoconfigure.metrics.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.actuate.autoconfigure.opentelemetry.OpenTelemetryProperties;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={OtlpMeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="otlp")
@EnableConfigurationProperties(value={OtlpProperties.class, OpenTelemetryProperties.class})
public class OtlpMetricsExportAutoConfiguration {
    private final OtlpProperties properties;

    OtlpMetricsExportAutoConfiguration(OtlpProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    OtlpMetricsConnectionDetails otlpMetricsConnectionDetails() {
        return new PropertiesOtlpMetricsConnectionDetails(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    OtlpConfig otlpConfig(OpenTelemetryProperties openTelemetryProperties, OtlpMetricsConnectionDetails connectionDetails, Environment environment2) {
        return new OtlpPropertiesConfigAdapter(this.properties, openTelemetryProperties, connectionDetails, environment2);
    }

    @Bean
    @ConditionalOnMissingBean
    public OtlpMeterRegistry otlpMeterRegistry(OtlpConfig otlpConfig, Clock clock) {
        return new OtlpMeterRegistry(otlpConfig, clock);
    }

    static class PropertiesOtlpMetricsConnectionDetails
    implements OtlpMetricsConnectionDetails {
        private final OtlpProperties properties;

        PropertiesOtlpMetricsConnectionDetails(OtlpProperties properties) {
            this.properties = properties;
        }

        @Override
        public String getUrl() {
            return this.properties.getUrl();
        }
    }
}

